/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import org.springframework.data.jdbc.core.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.Table;

class SqlContext {
    private final RelationalPersistentEntity<?> entity;
    private final Table table;

    SqlContext(RelationalPersistentEntity<?> entity) {
        this.entity = entity;
        this.table = SQL.table((String)entity.getTableName());
    }

    Column getIdColumn() {
        return this.table.column(this.entity.getIdColumn());
    }

    Table getTable() {
        return this.table;
    }

    Table getTable(PersistentPropertyPathExtension path) {
        String tableAlias = path.getTableAlias();
        Table table = SQL.table((String)path.getTableName());
        return tableAlias == null ? table : table.as(tableAlias);
    }

    Column getColumn(PersistentPropertyPathExtension path) {
        return this.getTable(path).column(path.getColumnName()).as(path.getColumnAlias());
    }

    Column getReverseColumn(PersistentPropertyPathExtension path) {
        return this.getTable(path).column(path.getReverseColumnName()).as(path.getReverseColumnNameAlias());
    }
}

