/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class PersistentPropertyPathExtension {
    private final RelationalPersistentEntity<?> entity;
    @Nullable
    private final PersistentPropertyPath<RelationalPersistentProperty> path;
    private final MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> context;

    PersistentPropertyPathExtension(MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> context, RelationalPersistentEntity<?> entity) {
        Assert.notNull(context, (String)"Context must not be null.");
        Assert.notNull(entity, (String)"Entity must not be null.");
        this.context = context;
        this.entity = entity;
        this.path = null;
    }

    PersistentPropertyPathExtension(MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> context, PersistentPropertyPath<RelationalPersistentProperty> path) {
        Assert.notNull(context, (String)"Context must not be null.");
        Assert.notNull(path, (String)"Path must not be null.");
        Assert.notNull((Object)path.getBaseProperty(), (String)"Path must not be empty.");
        this.context = context;
        this.entity = ((RelationalPersistentProperty)path.getBaseProperty()).getOwner();
        this.path = path;
    }

    boolean isEmbedded() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isEmbedded();
    }

    PersistentPropertyPathExtension getParentPath() {
        if (this.path == null) {
            throw new IllegalStateException("The parent path of a root path is not defined.");
        }
        if (this.path.getLength() == 1) {
            return new PersistentPropertyPathExtension(this.context, this.entity);
        }
        return new PersistentPropertyPathExtension(this.context, (PersistentPropertyPath<RelationalPersistentProperty>)this.path.getParentPath());
    }

    boolean isMultiValued() {
        return this.path != null && (((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isCollectionLike() || ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isQualified() || this.getParentPath().isMultiValued());
    }

    @Nullable
    RelationalPersistentEntity<?> getLeafEntity() {
        return this.path == null ? this.entity : (RelationalPersistentEntity)this.context.getPersistentEntity(((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getActualType());
    }

    boolean isEntity() {
        return this.path == null || ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isEntity();
    }

    boolean isQualified() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isQualified();
    }

    boolean isCollectionLike() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isCollectionLike();
    }

    String getReverseColumnName() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        return ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getReverseColumnName();
    }

    String getReverseColumnNameAlias() {
        return this.prefixWithTableAlias(this.getReverseColumnName());
    }

    String getColumnName() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        return this.assembleColumnName(((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getColumnName());
    }

    String getColumnAlias() {
        return this.prefixWithTableAlias(this.getColumnName());
    }

    boolean hasIdProperty() {
        RelationalPersistentEntity<?> leafEntity = this.getLeafEntity();
        return leafEntity != null && leafEntity.hasIdProperty();
    }

    PersistentPropertyPathExtension getIdDefiningParentPath() {
        PersistentPropertyPathExtension parent = this.getParentPath();
        if (parent.path == null) {
            return parent;
        }
        if (parent.isEmbedded()) {
            return this.getParentPath().getIdDefiningParentPath();
        }
        return parent;
    }

    String getTableName() {
        return this.getTableOwningAncestor().getRequiredLeafEntity().getTableName();
    }

    @Nullable
    String getTableAlias() {
        PersistentPropertyPathExtension tableOwner = this.getTableOwningAncestor();
        return tableOwner.path == null ? null : tableOwner.assembleTableAlias();
    }

    String getIdColumnName() {
        return this.getTableOwningAncestor().getRequiredLeafEntity().getIdColumn();
    }

    String getEffectiveIdColumnName() {
        PersistentPropertyPathExtension owner = this.getTableOwningAncestor();
        return owner.path == null ? owner.getRequiredLeafEntity().getIdColumn() : owner.getReverseColumnName();
    }

    int getLength() {
        return this.path == null ? 0 : this.path.getLength();
    }

    private PersistentPropertyPathExtension getTableOwningAncestor() {
        return this.isEntity() && !this.isEmbedded() ? this : this.getParentPath().getTableOwningAncestor();
    }

    private String assembleTableAlias() {
        String prefix;
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        RelationalPersistentProperty leafProperty = (RelationalPersistentProperty)this.path.getRequiredLeafProperty();
        String string = prefix = this.isEmbedded() ? leafProperty.getEmbeddedPrefix() : leafProperty.getName();
        if (this.path.getLength() == 1) {
            Assert.notNull((Object)prefix, (String)"Prefix mus not be null.");
            return prefix;
        }
        PersistentPropertyPathExtension parentPath = this.getParentPath();
        return parentPath.isEmbedded() ? parentPath.assembleTableAlias() + prefix : parentPath.assembleTableAlias() + "_" + prefix;
    }

    private String assembleColumnName(String suffix) {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        if (this.path.getLength() <= 1) {
            return suffix;
        }
        PersistentPropertyPath parentPath = this.path.getParentPath();
        RelationalPersistentProperty parentLeaf = (RelationalPersistentProperty)parentPath.getRequiredLeafProperty();
        if (!parentLeaf.isEmbedded()) {
            return suffix;
        }
        String embeddedPrefix = parentLeaf.getEmbeddedPrefix();
        return this.getParentPath().assembleColumnName(embeddedPrefix + suffix);
    }

    private RelationalPersistentEntity<?> getRequiredLeafEntity() {
        return this.path == null ? this.entity : (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getActualType());
    }

    private String prefixWithTableAlias(String columnName) {
        String tableAlias = this.getTableAlias();
        return tableAlias == null ? columnName : tableAlias + "_" + columnName;
    }
}

