/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.jdbc.core.IterableOfEntryToMapConverter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EntityRowMapper<T>
implements RowMapper<T> {
    private static final Converter<Iterable<?>, Map<?, ?>> ITERABLE_OF_ENTRY_TO_MAP_CONVERTER = new IterableOfEntryToMapConverter();
    private final RelationalPersistentEntity<T> entity;
    private final RelationalConverter converter;
    private final RelationalMappingContext context;
    private final DataAccessStrategy accessStrategy;
    private final RelationalPersistentProperty idProperty;

    public EntityRowMapper(RelationalPersistentEntity<T> entity, RelationalMappingContext context, RelationalConverter converter, DataAccessStrategy accessStrategy) {
        this.entity = entity;
        this.converter = converter;
        this.context = context;
        this.accessStrategy = accessStrategy;
        this.idProperty = (RelationalPersistentProperty)entity.getIdProperty();
    }

    public T mapRow(ResultSet resultSet, int rowNumber) {
        String prefix = "";
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)this.entity.getIdProperty();
        Object idValue = null;
        if (idProperty != null) {
            idValue = this.readFrom(resultSet, idProperty, prefix);
        }
        T result = this.createInstance(this.entity, resultSet, idValue, prefix);
        return this.entity.requiresPropertyPopulation() ? this.populateProperties(result, resultSet) : result;
    }

    private T populateProperties(T result, ResultSet resultSet) {
        PersistentPropertyAccessor propertyAccessor = this.converter.getPropertyAccessor(this.entity, result);
        Object id = this.idProperty == null ? null : this.readFrom(resultSet, this.idProperty, "");
        PreferredConstructor persistenceConstructor = this.entity.getPersistenceConstructor();
        for (RelationalPersistentProperty property : this.entity) {
            if (persistenceConstructor != null && persistenceConstructor.isConstructorParameter((PersistentProperty)property)) continue;
            propertyAccessor.setProperty((PersistentProperty)property, this.readOrLoadProperty(resultSet, id, property, ""));
        }
        return (T)propertyAccessor.getBean();
    }

    @Nullable
    private Object readOrLoadProperty(ResultSet resultSet, @Nullable Object id, RelationalPersistentProperty property, String prefix) {
        if (property.isCollectionLike() && property.isEntity() && id != null) {
            return this.accessStrategy.findAllByProperty(id, property);
        }
        if (property.isMap() && id != null) {
            return ITERABLE_OF_ENTRY_TO_MAP_CONVERTER.convert(this.accessStrategy.findAllByProperty(id, property));
        }
        if (property.isEmbedded()) {
            return this.readEmbeddedEntityFrom(resultSet, id, property, prefix);
        }
        return this.readFrom(resultSet, property, prefix);
    }

    @Nullable
    private Object readFrom(ResultSet resultSet, RelationalPersistentProperty property, String prefix) {
        if (property.isEntity()) {
            return this.readEntityFrom(resultSet, property, prefix);
        }
        Object value = this.getObjectFromResultSet(resultSet, prefix + property.getColumnName());
        return this.converter.readValue(value, property.getTypeInformation());
    }

    private Object readEmbeddedEntityFrom(ResultSet rs, @Nullable Object id, RelationalPersistentProperty property, String prefix) {
        String newPrefix = prefix + property.getEmbeddedPrefix();
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(property.getActualType());
        Object instance = this.createInstance(entity, rs, null, newPrefix);
        PersistentPropertyAccessor accessor = this.converter.getPropertyAccessor((PersistentEntity)entity, instance);
        for (RelationalPersistentProperty p : entity) {
            accessor.setProperty((PersistentProperty)p, this.readOrLoadProperty(rs, id, p, newPrefix));
        }
        return instance;
    }

    @Nullable
    private <S> S readEntityFrom(ResultSet rs, RelationalPersistentProperty property, String prefix) {
        String newPrefix = prefix + property.getName() + "_";
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(property.getActualType());
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getIdProperty();
        Object idValue = null;
        if (idProperty != null) {
            idValue = this.readFrom(rs, idProperty, newPrefix);
        }
        if ((idProperty != null ? idValue : this.getObjectFromResultSet(rs, newPrefix + property.getReverseColumnName())) == null) {
            return null;
        }
        S instance = this.createInstance(entity, rs, idValue, newPrefix);
        PersistentPropertyAccessor accessor = this.converter.getPropertyAccessor((PersistentEntity)entity, instance);
        for (RelationalPersistentProperty p : entity) {
            accessor.setProperty((PersistentProperty)p, this.readOrLoadProperty(rs, idValue, p, newPrefix));
        }
        return instance;
    }

    @Nullable
    private Object getObjectFromResultSet(ResultSet rs, String backreferenceName) {
        try {
            return rs.getObject(backreferenceName);
        }
        catch (SQLException o_O) {
            throw new MappingException(String.format("Could not read value %s from result set!", backreferenceName), (Throwable)o_O);
        }
    }

    private <S> S createInstance(RelationalPersistentEntity<S> entity, ResultSet rs, @Nullable Object idValue, String prefix) {
        return (S)this.converter.createInstance(entity, parameter -> {
            String parameterName = parameter.getName();
            Assert.notNull((Object)parameterName, (String)"A constructor parameter name must not be null to be used with Spring Data JDBC");
            RelationalPersistentProperty property = (RelationalPersistentProperty)entity.getRequiredPersistentProperty(parameterName);
            return this.readOrLoadProperty(rs, idValue, property, prefix);
        });
    }
}

