/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcIdentifierBuilder;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.Interpreter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.Identifier;
import org.springframework.lang.Nullable;

class DefaultJdbcInterpreter
implements Interpreter {
    private final RelationalMappingContext context;
    private final DataAccessStrategy accessStrategy;

    public <T> void interpret(DbAction.Insert<T> insert) {
        Object id = this.accessStrategy.insert(insert.getEntity(), insert.getEntityType(), this.getParentKeys((DbAction.WithDependingOn<?>)insert));
        insert.setGeneratedId(id);
    }

    public <T> void interpret(DbAction.InsertRoot<T> insert) {
        Object id = this.accessStrategy.insert(insert.getEntity(), insert.getEntityType(), Collections.emptyMap());
        insert.setGeneratedId(id);
    }

    public <T> void interpret(DbAction.Update<T> update) {
        this.accessStrategy.update(update.getEntity(), update.getEntityType());
    }

    public <T> void interpret(DbAction.UpdateRoot<T> update) {
        this.accessStrategy.update(update.getEntity(), update.getEntityType());
    }

    public <T> void interpret(DbAction.Merge<T> merge) {
        if (!this.accessStrategy.update(merge.getEntity(), merge.getEntityType())) {
            this.accessStrategy.insert(merge.getEntity(), merge.getEntityType(), this.getParentKeys((DbAction.WithDependingOn<?>)merge));
        }
    }

    public <T> void interpret(DbAction.Delete<T> delete) {
        this.accessStrategy.delete(delete.getRootId(), (PersistentPropertyPath<RelationalPersistentProperty>)delete.getPropertyPath());
    }

    public <T> void interpret(DbAction.DeleteRoot<T> delete) {
        this.accessStrategy.delete(delete.getRootId(), delete.getEntityType());
    }

    public <T> void interpret(DbAction.DeleteAll<T> delete) {
        this.accessStrategy.deleteAll((PersistentPropertyPath<RelationalPersistentProperty>)delete.getPropertyPath());
    }

    public <T> void interpret(DbAction.DeleteAllRoot<T> deleteAllRoot) {
        this.accessStrategy.deleteAll(deleteAllRoot.getEntityType());
    }

    private Identifier getParentKeys(DbAction.WithDependingOn<?> action) {
        DbAction.WithEntity dependingOn = action.getDependingOn();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(dependingOn.getEntityType());
        Object id = this.getIdFromEntityDependingOn(dependingOn, persistentEntity);
        JdbcIdentifierBuilder identifier = JdbcIdentifierBuilder.forBackReferences((PersistentPropertyPath<RelationalPersistentProperty>)action.getPropertyPath(), id);
        for (Map.Entry qualifier : action.getQualifiers().entrySet()) {
            identifier = identifier.withQualifier((PersistentPropertyPath<RelationalPersistentProperty>)((PersistentPropertyPath)qualifier.getKey()), qualifier.getValue());
        }
        return identifier.build();
    }

    @Nullable
    private Object getIdFromEntityDependingOn(DbAction.WithEntity<?> dependingOn, RelationalPersistentEntity<?> persistentEntity) {
        Object generatedId;
        Object entity = dependingOn.getEntity();
        if (dependingOn instanceof DbAction.WithGeneratedId && (generatedId = ((DbAction.WithGeneratedId)dependingOn).getGeneratedId()) != null) {
            return generatedId;
        }
        return persistentEntity.getIdentifierAccessor(entity).getIdentifier();
    }

    public DefaultJdbcInterpreter(RelationalMappingContext context, DataAccessStrategy accessStrategy) {
        this.context = context;
        this.accessStrategy = accessStrategy;
    }
}

