/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import lombok.NonNull;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.jdbc.core.EntityRowMapper;
import org.springframework.data.jdbc.core.MapEntityRowMapper;
import org.springframework.data.jdbc.core.SqlGenerator;
import org.springframework.data.jdbc.core.SqlGeneratorSource;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcValue;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.Identifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultDataAccessStrategy
implements DataAccessStrategy {
    @NonNull
    private final SqlGeneratorSource sqlGeneratorSource;
    @NonNull
    private final RelationalMappingContext context;
    @NonNull
    private final JdbcConverter converter;
    @NonNull
    private final NamedParameterJdbcOperations operations;
    @NonNull
    private final DataAccessStrategy accessStrategy;

    public DefaultDataAccessStrategy(SqlGeneratorSource sqlGeneratorSource, RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations) {
        this(sqlGeneratorSource, context, converter, operations, null);
    }

    public DefaultDataAccessStrategy(SqlGeneratorSource sqlGeneratorSource, RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations, @Nullable DataAccessStrategy mappingAccessStrategy) {
        Assert.notNull((Object)sqlGeneratorSource, (String)"SqlGeneratorSource must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.context = context;
        this.converter = converter;
        this.operations = operations;
        this.accessStrategy = mappingAccessStrategy == null ? this : mappingAccessStrategy;
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Map<String, Object> additionalParameters) {
        return this.insert(instance, domainType, Identifier.from(additionalParameters));
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier) {
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        MapSqlParameterSource parameterSource = this.getParameterSource(instance, persistentEntity, "", PersistentProperty::isIdProperty);
        identifier.forEach((name, value, type) -> this.addConvertedPropertyValue(parameterSource, name, value, type));
        Object idValue = this.getIdValueOrNull(instance, persistentEntity);
        if (idValue != null) {
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getRequiredIdProperty();
            this.addConvertedPropertyValue(parameterSource, idProperty, idValue, idProperty.getColumnName());
        }
        this.operations.update(this.sql(domainType).getInsert(new HashSet<String>(Arrays.asList(parameterSource.getParameterNames()))), (SqlParameterSource)parameterSource, (KeyHolder)holder);
        return this.getIdFromHolder((KeyHolder)holder, persistentEntity);
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        RelationalPersistentEntity<S> persistentEntity = this.getRequiredPersistentEntity(domainType);
        return this.operations.update(this.sql(domainType).getUpdate(), (SqlParameterSource)this.getParameterSource(instance, persistentEntity, "", Predicates.includeAll())) != 0;
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        String deleteByIdSql = this.sql(domainType).getDeleteById();
        MapSqlParameterSource parameter = this.createIdParameterSource(id, domainType);
        this.operations.update(deleteByIdSql, (SqlParameterSource)parameter);
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        RelationalPersistentEntity rootEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType());
        RelationalPersistentProperty referencingProperty = (RelationalPersistentProperty)propertyPath.getLeafProperty();
        Assert.notNull((Object)referencingProperty, (String)("No property found matching the PropertyPath " + propertyPath));
        String format = this.sql(rootEntity.getType()).createDeleteByPath(propertyPath);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootId", rootId);
        this.operations.update(format, parameters);
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.operations.getJdbcOperations().update(this.sql(domainType).createDeleteAllSql(null));
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.operations.getJdbcOperations().update(this.sql(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType()).createDeleteAllSql(propertyPath));
    }

    @Override
    public long count(Class<?> domainType) {
        Long result = (Long)this.operations.getJdbcOperations().queryForObject(this.sql(domainType).getCount(), Long.class);
        Assert.notNull((Object)result, (String)"The result of a count query must not be null.");
        return result;
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        String findOneSql = this.sql(domainType).getFindOne();
        MapSqlParameterSource parameter = this.createIdParameterSource(id, domainType);
        try {
            return (T)this.operations.queryForObject(findOneSql, (SqlParameterSource)parameter, this.getEntityRowMapper(domainType));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.operations.query(this.sql(domainType).getFindAll(), this.getEntityRowMapper(domainType));
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)this.getRequiredPersistentEntity(domainType).getRequiredIdProperty();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        this.addConvertedPropertyValuesAsList(parameterSource, idProperty, ids, "ids");
        String findAllInListSql = this.sql(domainType).getFindAllInList();
        return this.operations.query(findAllInListSql, (SqlParameterSource)parameterSource, this.getEntityRowMapper(domainType));
    }

    @Override
    public <T> Iterable<T> findAllByProperty(Object rootId, RelationalPersistentProperty property) {
        Assert.notNull((Object)rootId, (String)"rootId must not be null.");
        Class actualType = property.getActualType();
        String findAllByProperty = this.sql(actualType).getFindAllByProperty(property.getReverseColumnName(), property.getKeyColumn(), property.isOrdered());
        MapSqlParameterSource parameter = new MapSqlParameterSource(property.getReverseColumnName(), rootId);
        return this.operations.query(findAllByProperty, (SqlParameterSource)parameter, property.isMap() ? this.getMapEntityRowMapper(property) : this.getEntityRowMapper(actualType));
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        String existsSql = this.sql(domainType).getExists();
        MapSqlParameterSource parameter = this.createIdParameterSource(id, domainType);
        Boolean result = (Boolean)this.operations.queryForObject(existsSql, (SqlParameterSource)parameter, Boolean.class);
        Assert.notNull((Object)result, (String)"The result of an exists query must not be null");
        return result;
    }

    private <S, T> MapSqlParameterSource getParameterSource(S instance, RelationalPersistentEntity<S> persistentEntity, String prefix, Predicate<RelationalPersistentProperty> skipProperty) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(instance);
        persistentEntity.doWithProperties(property -> {
            if (skipProperty.test((RelationalPersistentProperty)property)) {
                return;
            }
            if (property.isEntity() && !property.isEmbedded()) {
                return;
            }
            if (property.isEmbedded()) {
                Object value = propertyAccessor.getProperty(property);
                RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(property.getType());
                MapSqlParameterSource additionalParameters = this.getParameterSource(value, embeddedEntity, prefix + property.getEmbeddedPrefix(), skipProperty);
                parameters.addValues(additionalParameters.getValues());
            } else {
                Object value = propertyAccessor.getProperty(property);
                String paramName = prefix + property.getColumnName();
                this.addConvertedPropertyValue(parameters, (RelationalPersistentProperty)property, value, paramName);
            }
        });
        return parameters;
    }

    @Nullable
    private <S, ID> ID getIdValueOrNull(S instance, RelationalPersistentEntity<S> persistentEntity) {
        Object idValue = persistentEntity.getIdentifierAccessor(instance).getIdentifier();
        return (ID)(DefaultDataAccessStrategy.isIdPropertyNullOrScalarZero(idValue, persistentEntity) ? null : idValue);
    }

    private static <S, ID> boolean isIdPropertyNullOrScalarZero(@Nullable ID idValue, RelationalPersistentEntity<S> persistentEntity) {
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        return idValue == null || idProperty == null || idProperty.getType() == Integer.TYPE && idValue.equals(0) || idProperty.getType() == Long.TYPE && idValue.equals(0L);
    }

    @Nullable
    private <S> Object getIdFromHolder(KeyHolder holder, RelationalPersistentEntity<S> persistentEntity) {
        try {
            return holder.getKey();
        }
        catch (DataRetrievalFailureException | InvalidDataAccessApiUsageException e) {
            Map keys = holder.getKeys();
            if (keys == null || persistentEntity.getIdProperty() == null) {
                return null;
            }
            return keys.get(persistentEntity.getIdColumn());
        }
    }

    private EntityRowMapper<?> getEntityRowMapper(Class<?> domainType) {
        return new EntityRowMapper(this.getRequiredPersistentEntity(domainType), this.context, this.converter, this.accessStrategy);
    }

    private RowMapper<?> getMapEntityRowMapper(RelationalPersistentProperty property) {
        String keyColumn = property.getKeyColumn();
        Assert.notNull((Object)keyColumn, () -> "KeyColumn must not be null for " + property);
        return new MapEntityRowMapper(this.getEntityRowMapper(property.getActualType()), keyColumn);
    }

    private <T> MapSqlParameterSource createIdParameterSource(Object id, Class<T> domainType) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        this.addConvertedPropertyValue(parameterSource, (RelationalPersistentProperty)this.getRequiredPersistentEntity(domainType).getRequiredIdProperty(), id, "id");
        return parameterSource;
    }

    private void addConvertedPropertyValue(MapSqlParameterSource parameterSource, RelationalPersistentProperty property, Object value, String paramName) {
        JdbcValue jdbcValue = this.converter.writeJdbcValue(value, property.getColumnType(), property.getSqlType());
        parameterSource.addValue(paramName, jdbcValue.getValue(), JdbcUtil.sqlTypeFor(jdbcValue.getJdbcType()));
    }

    private void addConvertedPropertyValue(MapSqlParameterSource parameterSource, String name, Object value, Class<?> type) {
        JdbcValue jdbcValue = this.converter.writeJdbcValue(value, type, JdbcUtil.sqlTypeFor(type));
        parameterSource.addValue(name, jdbcValue.getValue(), JdbcUtil.sqlTypeFor(jdbcValue.getJdbcType()));
    }

    private void addConvertedPropertyValuesAsList(MapSqlParameterSource parameterSource, RelationalPersistentProperty property, Iterable<?> values, String paramName) {
        ArrayList<Object> convertedIds = new ArrayList<Object>();
        JdbcValue jdbcValue = null;
        for (Object id : values) {
            Class columnType = property.getColumnType();
            int sqlType = property.getSqlType();
            jdbcValue = this.converter.writeJdbcValue(id, columnType, sqlType);
            convertedIds.add(jdbcValue.getValue());
        }
        Assert.notNull(jdbcValue, (String)"JdbcValue must be not null at this point. Please report this as a bug.");
        JDBCType jdbcType = jdbcValue.getJdbcType();
        int typeNumber = jdbcType == null ? Integer.MIN_VALUE : jdbcType.getVendorTypeNumber();
        parameterSource.addValue(paramName, convertedIds, typeNumber);
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
    }

    private SqlGenerator sql(Class<?> domainType) {
        return this.sqlGeneratorSource.getSqlGenerator(domainType);
    }

    static class Predicates {
        Predicates() {
        }

        static Predicate<RelationalPersistentProperty> includeAll() {
            return it -> false;
        }
    }
}

