/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.annotation.configuration;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.hadoop.config.annotation.SpringHadoopConfigs;
import org.springframework.data.hadoop.config.annotation.builders.SpringHadoopConfigBuilder;
import org.springframework.data.hadoop.config.common.annotation.AbstractAnnotationConfiguration;
import org.springframework.data.hadoop.config.common.annotation.AnnotationConfigurer;

@Configuration
public class SpringHadoopConfiguration
extends AbstractAnnotationConfiguration<SpringHadoopConfigBuilder, SpringHadoopConfigs> {
    private static final Log log = LogFactory.getLog(SpringHadoopConfiguration.class);
    protected final SpringHadoopConfigBuilder builder = new SpringHadoopConfigBuilder();

    @Override
    protected void onConfigurers(List<AnnotationConfigurer<SpringHadoopConfigs, SpringHadoopConfigBuilder>> configurers) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("onConfigurers: " + configurers));
        }
        for (AnnotationConfigurer<SpringHadoopConfigs, SpringHadoopConfigBuilder> configurer : configurers) {
            this.builder.apply(configurer);
        }
    }

    @Bean(name={"hadoopConfiguration"})
    public org.apache.hadoop.conf.Configuration configuration() throws Exception {
        log.info((Object)"Building configuration for bean 'hadoopConfiguration'");
        return ((SpringHadoopConfigs)this.builder.getOrBuild()).getConfiguration();
    }
}

