/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.springframework.util.Assert;

public class StreamsHolder<T extends Closeable>
implements Closeable {
    private T stream;
    private T wrappedStream;
    private Path path;

    public StreamsHolder() {
    }

    public StreamsHolder(T stream, T wrappedStream) {
        this(stream, wrappedStream, null);
    }

    public StreamsHolder(T stream, T wrappedStream, Path path) {
        Assert.notNull(stream, (String)"Main stream should not be null");
        this.stream = stream;
        this.wrappedStream = wrappedStream;
        this.path = path;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.wrappedStream != null) {
            try {
                this.wrappedStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public T getStream() {
        return this.stream;
    }

    public void setStream(T stream) {
        this.stream = stream;
    }

    public T getWrappedStream() {
        return this.wrappedStream;
    }

    public void setWrappedStream(T wrappedStream) {
        this.wrappedStream = wrappedStream;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }
}

