/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.util.Assert;

public abstract class StoreUtils {
    private static final String utf8 = "UTF-8";
    private static final byte[] delimiter;
    private static final byte[] csv;
    private static final byte[] tab;
    public static final int BUFFER_SIZE = 4096;

    public static byte[] getUTF8DefaultDelimiter() {
        return delimiter;
    }

    public static byte[] getUTF8CsvDelimiter() {
        return csv;
    }

    public static byte[] getUTF8TabDelimiter() {
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, DataStoreWriter<byte[]> out) throws IOException {
        Assert.notNull((Object)in, (String)"No InputStream specified");
        Assert.notNull(out, (String)"No DataStoreWriter specified");
        try {
            int n = StoreUtils.copyStream(in, out);
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static int copyStream(InputStream in, DataStoreWriter<byte[]> out) throws IOException {
        Assert.notNull((Object)in, (String)"No InputStream specified");
        Assert.notNull(out, (String)"No DataStoreWriter specified");
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = in.read(buffer)) != -1) {
            if (bytesRead < 4096) {
                byte[] buf = new byte[bytesRead];
                System.arraycopy(buffer, 0, buf, 0, bytesRead);
                out.write(buf);
            } else {
                out.write(buffer);
            }
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    static {
        try {
            delimiter = "\n".getBytes(utf8);
            csv = ",".getBytes(utf8);
            tab = "\t".getBytes(utf8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("can't find UTF-8 encoding");
        }
    }
}

