/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.strategy.rollover;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.hadoop.store.strategy.rollover.RolloverStrategy;
import org.springframework.data.hadoop.store.support.OrderedComposite;

public class ChainedRolloverStrategy
implements RolloverStrategy {
    private OrderedComposite<RolloverStrategy> strategies = new OrderedComposite();

    public ChainedRolloverStrategy() {
        this(Collections.emptyList());
    }

    public ChainedRolloverStrategy(List<? extends RolloverStrategy> strategies) {
        this.setStrategies(strategies);
    }

    @Override
    public boolean hasRolled() {
        Iterator<RolloverStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().hasRolled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        Iterator<RolloverStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
        }
    }

    @Override
    public void setWritePosition(long position) {
        Iterator<RolloverStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext()) {
            iterator.next().setWritePosition(position);
        }
    }

    @Override
    public ChainedRolloverStrategy createInstance() {
        ChainedRolloverStrategy instance = new ChainedRolloverStrategy();
        for (RolloverStrategy strategy : this.strategies.getItems()) {
            instance.register((RolloverStrategy)strategy.createInstance());
        }
        return instance;
    }

    public void setStrategies(List<? extends RolloverStrategy> strategies) {
        this.strategies.setItems(strategies);
    }

    public void register(RolloverStrategy strategy) {
        this.strategies.add(strategy);
    }

    public List<? extends RolloverStrategy> getStrategies() {
        return this.strategies.getItems();
    }
}

