/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.strategy.naming;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.strategy.naming.AbstractFileNamingStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class UuidFileNamingStrategy
extends AbstractFileNamingStrategy {
    private static final Log log = LogFactory.getLog(UuidFileNamingStrategy.class);
    private String uuid;
    private volatile String prefix = "-";

    public UuidFileNamingStrategy() {
        this(UUID.randomUUID().toString());
    }

    public UuidFileNamingStrategy(String uuid) {
        this.uuid = uuid;
    }

    public UuidFileNamingStrategy(String uuid, boolean enabled) {
        this.uuid = uuid;
        this.setEnabled(enabled);
    }

    @Override
    public Path resolve(Path path) {
        if (this.isEnabled()) {
            if (path != null) {
                return new Path(path.getParent(), path.getName() + this.prefix + this.uuid);
            }
            return new Path(this.prefix + this.uuid);
        }
        return path;
    }

    @Override
    public Path init(Path path) {
        path = super.init(path);
        log.debug((Object)("Init using path=[" + path + "]"));
        if (path != null && this.isEnabled()) {
            String oldName = path.getName();
            String newName = StringUtils.replace((String)oldName, (String)(this.prefix + this.uuid), (String)"");
            if (!StringUtils.hasText((String)newName)) {
                path = null;
                log.debug((Object)"Removed last handled name part, returning null");
            } else if (!ObjectUtils.nullSafeEquals((Object)oldName, (Object)newName)) {
                path = new Path(path.getParent(), newName);
                log.debug((Object)("Removed handled prefix, path is now " + newName));
            }
        }
        return path;
    }

    @Override
    public void next() {
    }

    @Override
    public UuidFileNamingStrategy createInstance() {
        UuidFileNamingStrategy instance = new UuidFileNamingStrategy(this.uuid, this.isEnabled());
        instance.setOrder(this.getOrder());
        instance.setEnabled(this.isEnabled());
        instance.setPrefix(this.prefix);
        return instance;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setPrefix(String prefix) {
        Assert.notNull((Object)prefix, (String)"Prefix cannot be null");
        this.prefix = prefix;
    }
}

