/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.strategy.naming;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.strategy.naming.AbstractFileNamingStrategy;
import org.springframework.util.StringUtils;

public class RollingFileNamingStrategy
extends AbstractFileNamingStrategy {
    private static final Log log = LogFactory.getLog(RollingFileNamingStrategy.class);
    private volatile int counter = 0;
    private volatile String prefix = "-";

    @Override
    public Path resolve(Path path) {
        if (!this.isEnabled()) {
            return path;
        }
        if (path != null) {
            return new Path(path.getParent(), path.getName() + this.prefix + Integer.toString(this.counter));
        }
        return new Path(Integer.toString(this.counter));
    }

    @Override
    public void next() {
        ++this.counter;
    }

    @Override
    public void reset() {
        this.counter = 0;
    }

    @Override
    public Path init(Path path) {
        path = super.init(path);
        log.debug((Object)("Initialising from path=" + path));
        if (path != null) {
            String name = path.getName();
            Pattern counterPattern = Pattern.compile(this.prefix + "(" + "\\d+" + ")");
            Matcher m = counterPattern.matcher(name);
            while (m.find()) {
                try {
                    this.counter = Integer.parseInt(m.group(1)) + 1;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            log.debug((Object)("Initialized counter starting from " + this.counter));
            Pattern replacePattern = Pattern.compile("(" + this.prefix + "\\d+" + ")(.*)");
            m = replacePattern.matcher(name);
            name = m.replaceFirst("$2");
            if (StringUtils.hasText((String)name)) {
                path = new Path(path.getParent(), name);
                log.debug((Object)("Removed handled prefix, path is now " + path));
            } else {
                path = null;
                log.debug((Object)"Removed last handled name part, returning null");
            }
        }
        return path;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public RollingFileNamingStrategy createInstance() {
        RollingFileNamingStrategy instance = new RollingFileNamingStrategy();
        instance.setCodecInfo(this.getCodecInfo());
        instance.setOrder(this.getOrder());
        instance.setEnabled(this.isEnabled());
        instance.setPrefix(this.prefix);
        return instance;
    }
}

