/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.strategy.naming;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.strategy.naming.AbstractFileNamingStrategy;
import org.springframework.util.StringUtils;

public class CodecFileNamingStrategy
extends AbstractFileNamingStrategy {
    private static final Log log = LogFactory.getLog(CodecFileNamingStrategy.class);

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }

    @Override
    public Path resolve(Path path) {
        String suffix;
        if (!this.isEnabled()) {
            return path;
        }
        CodecInfo c = this.getCodecInfo();
        String string = suffix = c != null ? "." + c.getDefaultSuffix() : "";
        if (path != null) {
            return path.suffix(suffix);
        }
        if (StringUtils.hasText((String)suffix)) {
            return new Path(suffix);
        }
        return path;
    }

    @Override
    public void next() {
    }

    @Override
    public Path init(Path path) {
        String suffix;
        path = super.init(path);
        log.debug((Object)("Initialising from path=" + path));
        CodecInfo c = this.getCodecInfo();
        String string = suffix = c != null ? "." + c.getDefaultSuffix() : "";
        if (path != null && StringUtils.hasText((String)suffix) && path.getName().startsWith(suffix)) {
            String name = path.getName().substring(suffix.length());
            if (StringUtils.hasText((String)name)) {
                path = new Path(path.getParent(), name);
                log.debug((Object)("Removed handled prefix, path is now " + path));
            } else {
                path = null;
                log.debug((Object)"Removed last handled name part, returning null");
            }
        }
        return path;
    }

    @Override
    public CodecFileNamingStrategy createInstance() {
        CodecFileNamingStrategy instance = new CodecFileNamingStrategy();
        instance.setCodecInfo(this.getCodecInfo());
        instance.setOrder(this.getOrder());
        instance.setEnabled(this.isEnabled());
        return instance;
    }
}

