/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.split;

import org.springframework.data.hadoop.store.split.Split;
import org.springframework.data.hadoop.store.split.SplitLocation;

public class GenericSplit
implements Split,
SplitLocation {
    private long start;
    private long length;
    private String[] locations;

    public GenericSplit() {
    }

    public GenericSplit(long start, long length, String[] locations) {
        this.start = start;
        this.length = length;
        this.locations = locations;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getEnd() {
        return this.getStart() + this.getLength();
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public String[] getLocations() {
        return this.locations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericSplit other = (GenericSplit)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.start == other.start;
    }
}

