/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.partition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.expression.MessageExpressionMethods;
import org.springframework.data.hadoop.store.partition.AbstractPartitionStrategy;
import org.springframework.data.hadoop.store.partition.PartitionKeyResolver;
import org.springframework.data.hadoop.store.partition.PartitionResolver;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class MessagePartitionStrategy<T>
extends AbstractPartitionStrategy<T, Message<?>> {
    private static final Log log = LogFactory.getLog(MessagePartitionStrategy.class);

    public MessagePartitionStrategy(Expression expression, StandardEvaluationContext evaluationContext) {
        super(new MessagePartitionResolver(expression, evaluationContext), new MessagePartitionKeyResolver());
    }

    public MessagePartitionStrategy(String expression, StandardEvaluationContext evaluationContext) {
        this(expression, evaluationContext, null);
    }

    public MessagePartitionStrategy(String expression, StandardEvaluationContext evaluationContext, ExpressionParser expressionParser) {
        super(new MessagePartitionResolver(expression, evaluationContext, expressionParser), new MessagePartitionKeyResolver());
    }

    private static class MessagePartitionKeyResolver<T>
    implements PartitionKeyResolver<T, Message<?>> {
        private MessagePartitionKeyResolver() {
        }

        @Override
        public Message<?> resolvePartitionKey(T entity) {
            return MessageBuilder.withPayload(entity).build();
        }
    }

    private static class MessagePartitionResolver
    implements PartitionResolver<Message<?>> {
        private final Expression expression;
        private final MessageExpressionMethods methods;

        public MessagePartitionResolver(String expression, StandardEvaluationContext evaluationContext, ExpressionParser expressionParser) {
            if (expressionParser == null) {
                expressionParser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
            }
            this.expression = expressionParser.parseExpression(expression);
            this.methods = new MessageExpressionMethods(evaluationContext, true, true);
            log.info((Object)("Using expression=[" + this.expression.getExpressionString() + "]"));
        }

        public MessagePartitionResolver(Expression expression, StandardEvaluationContext evaluationContext) {
            this.expression = expression;
            this.methods = new MessageExpressionMethods(evaluationContext);
            log.info((Object)("Using expression=[" + this.expression.getExpressionString() + "]"));
        }

        @Override
        public Path resolvePath(Message<?> partitionKey) {
            return new Path(this.methods.getValue(this.expression, partitionKey, String.class));
        }
    }
}

