/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.output;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.event.FileWrittenEvent;
import org.springframework.data.hadoop.store.event.StoreEventPublisher;
import org.springframework.data.hadoop.store.output.AbstractSequenceFileWriter;
import org.springframework.data.hadoop.store.support.OutputContext;
import org.springframework.data.hadoop.store.support.SequenceFileWriterHolder;

public class TextSequenceFileWriter
extends AbstractSequenceFileWriter
implements DataStoreWriter<String> {
    private static final Log log = LogFactory.getLog(TextSequenceFileWriter.class);
    private SequenceFileWriterHolder<SequenceFile.Writer> holder;
    private static final Text NULL_KEY = new Text(new byte[0]);

    public TextSequenceFileWriter(Configuration configuration, Path basePath, CodecInfo codec) {
        super(configuration, basePath, codec);
    }

    @Override
    public void flush() throws IOException {
    }

    public synchronized void hflush() throws IOException {
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.holder != null) {
            this.holder.close();
            Path path = this.renameFile(this.holder.getPath());
            StoreEventPublisher storeEventPublisher = this.getStoreEventPublisher();
            if (storeEventPublisher != null) {
                storeEventPublisher.publishEvent(new FileWrittenEvent(this, path));
            }
            this.holder = null;
        }
    }

    @Override
    public synchronized void write(String entity) throws IOException {
        if (this.holder == null) {
            this.holder = this.getOutput();
        }
        this.holder.getWriter().append((Writable)NULL_KEY, (Writable)new Text(entity.getBytes()));
        this.setWritePosition(this.getPosition(this.holder.getWriter()));
        OutputContext context = this.getOutputContext();
        if (context.getRolloverState()) {
            log.info((Object)"After write, rollover state is true");
            this.close();
            context.rollStrategies();
        }
    }

    @Override
    protected void handleTimeout() {
        try {
            if (this.isAppendable()) {
                log.info((Object)"Timeout detected for this writer, flushing stream");
                this.hflush();
            } else {
                log.info((Object)"Timeout detected for this writer, closing stream");
                this.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error closing", (Throwable)e);
        }
        this.getOutputContext().rollStrategies();
    }
}

