/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.input;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.springframework.data.hadoop.store.DataStoreReader;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.input.AbstractSequenceFileReader;

public class TextSequenceFileReader
extends AbstractSequenceFileReader
implements DataStoreReader<String> {
    private SequenceFile.Reader reader;

    public TextSequenceFileReader(Configuration configuration, Path basePath, CodecInfo codec) {
        super(configuration, basePath, codec);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public String read() throws IOException {
        if (this.reader == null) {
            this.reader = this.getInput();
        }
        Text k = new Text();
        Text v = new Text();
        this.reader.next((Writable)k, (Writable)v);
        byte[] value = v.getBytes();
        return value != null && value.length > 0 ? new String(value) : null;
    }
}

