/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.springframework.data.hadoop.store.expression.MessagePartitionKeyMethodResolver;
import org.springframework.data.hadoop.store.expression.MessagePartitionKeyPropertyAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;

public class MessageExpressionMethods {
    private final StandardEvaluationContext context;

    public MessageExpressionMethods(StandardEvaluationContext evaluationContext) {
        this(evaluationContext, false, false);
    }

    public MessageExpressionMethods(StandardEvaluationContext evaluationContext, boolean autoCustomize, boolean replaceMethodResolver) {
        Assert.notNull((Object)evaluationContext, (String)"Evaluation context cannot be null");
        if (autoCustomize) {
            MessagePartitionKeyMethodResolver methodResolver = new MessagePartitionKeyMethodResolver();
            if (replaceMethodResolver) {
                ArrayList<MessagePartitionKeyMethodResolver> methodResolvers = new ArrayList<MessagePartitionKeyMethodResolver>();
                methodResolvers.add(methodResolver);
                evaluationContext.setMethodResolvers(methodResolvers);
            } else {
                evaluationContext.addMethodResolver((MethodResolver)methodResolver);
            }
        }
        if (autoCustomize) {
            evaluationContext.addPropertyAccessor((PropertyAccessor)new MessagePartitionKeyPropertyAccessor());
        }
        this.context = evaluationContext;
    }

    public <T> T getValue(Expression expression, Message<?> message, Class<T> desiredResultType) throws EvaluationException {
        Assert.notNull((Object)expression, (String)"Expression cannot be null");
        return (T)expression.getValue((EvaluationContext)this.context, (Object)new MessageWrappedMessage(message), desiredResultType);
    }

    public static class MessageWrappedMessage
    implements Message<Object> {
        private final Message<?> delegate;

        public MessageWrappedMessage(Message<?> delegate) {
            this.delegate = delegate;
        }

        public Object getPayload() {
            return this.delegate.getPayload();
        }

        public MessageHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        public String dateFormat(String pattern) {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.format(this.getHeaders().getTimestamp());
        }
    }
}

