/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;

public class DateFormatMethodExecutor
implements MethodExecutor {
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd";
    private String key;

    public DateFormatMethodExecutor() {
    }

    public DateFormatMethodExecutor(String key) {
        this.key = key;
    }

    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        if (this.key == null) {
            SimpleDateFormat format = new SimpleDateFormat((String)arguments[0]);
            if (arguments[1] instanceof Long || arguments[1] instanceof Date) {
                return new TypedValue((Object)format.format(arguments[1]));
            }
            if (arguments[1] instanceof String) {
                SimpleDateFormat fromFormat = new SimpleDateFormat(DEFAULT_FORMAT);
                if (arguments.length == 3 && arguments[2] instanceof String) {
                    fromFormat = new SimpleDateFormat((String)arguments[2]);
                }
                try {
                    Date parsedDate = fromFormat.parse((String)arguments[1]);
                    return new TypedValue((Object)format.format(parsedDate));
                }
                catch (ParseException e) {
                    throw new AccessException("Unable to format", (Exception)e);
                }
            }
            return new TypedValue((Object)format.format((Long)arguments[1]));
        }
        throw new AccessException("Unable to format");
    }

    protected String getKey() {
        return this.key;
    }

    public static String dateFormat(String pattern, Integer epoch) throws AccessException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(epoch);
    }

    public static String dateFormat(String pattern, Long epoch) throws AccessException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(epoch);
    }

    public static String dateFormat(String pattern, Date date) throws AccessException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String dateFormat(String pattern, String datestring) throws AccessException {
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            SimpleDateFormat fromFormat = new SimpleDateFormat(DEFAULT_FORMAT);
            Date parsedDate = fromFormat.parse(datestring);
            return format.format(parsedDate);
        }
        catch (ParseException e) {
            throw new AccessException("Unable to format", (Exception)e);
        }
    }

    public static String dateFormat(String pattern, String datestring, String dateformat) throws AccessException {
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            SimpleDateFormat fromFormat = new SimpleDateFormat(dateformat);
            Date parsedDate = fromFormat.parse(datestring);
            return format.format(parsedDate);
        }
        catch (ParseException e) {
            throw new AccessException("Unable to format", (Exception)e);
        }
    }
}

