/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetNotFoundException;
import org.springframework.data.hadoop.store.dataset.DatasetDefinition;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryFactory;

public abstract class DatasetUtils {
    private static final Log log = LogFactory.getLog(DatasetUtils.class);

    public static <T> String getDatasetName(Class<T> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public static <T> Dataset<T> getOrCreateDataset(DatasetRepositoryFactory dsFactory, DatasetDefinition datasetDefinition, Class<?> pojoClass, Class<T> recordClass) {
        Dataset dataset;
        String repoName = DatasetUtils.getDatasetName(pojoClass);
        try {
            dataset = dsFactory.getDatasetRepository().load(dsFactory.getNamespace(), repoName);
            log.debug((Object)("Found dataset for " + repoName));
        }
        catch (DatasetNotFoundException ex) {
            DatasetDescriptor descriptor;
            Schema schema = datasetDefinition.getSchema(pojoClass);
            log.debug((Object)("Creating dataset for " + repoName + " using schema " + schema));
            if (recordClass != null && recordClass.isAssignableFrom(GenericRecord.class)) {
                Schema genericSchema = Schema.createRecord((String)("Generic" + schema.getName()), (String)("Generic representation of " + schema.getName()), (String)schema.getNamespace(), (boolean)false);
                ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                for (Schema.Field f : schema.getFields()) {
                    fields.add(new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultValue()));
                }
                genericSchema.setFields(fields);
                schema = genericSchema;
            }
            if (datasetDefinition.getPartitionStrategy() == null) {
                descriptor = new DatasetDescriptor.Builder().schema(schema).format(datasetDefinition.getFormat()).compressionType(datasetDefinition.getCompressionType()).build();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using partitioning: " + datasetDefinition.getPartitionStrategy()));
                }
                DatasetDescriptor.Builder ddBuilder = new DatasetDescriptor.Builder().schema(schema).format(datasetDefinition.getFormat()).compressionType(datasetDefinition.getCompressionType()).partitionStrategy(datasetDefinition.getPartitionStrategy());
                if (datasetDefinition.getWriterCacheSize() != null) {
                    ddBuilder = ddBuilder.property("kite.writer.cache-size", Integer.toString(datasetDefinition.getWriterCacheSize()));
                }
                descriptor = ddBuilder.build();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using descriptor: " + descriptor));
                }
            }
            dataset = dsFactory.getDatasetRepository().create(dsFactory.getNamespace(), repoName, descriptor);
        }
        return dataset;
    }

    public static <T> Dataset<T> getDataset(DatasetRepositoryFactory dsFactory, Class<T> pojoClass) {
        String repoName = DatasetUtils.getDatasetName(pojoClass);
        return dsFactory.getDatasetRepository().load(dsFactory.getNamespace(), repoName);
    }
}

