/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.config.annotation.configuration;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.hadoop.config.common.annotation.AbstractImportingAnnotationConfiguration;
import org.springframework.data.hadoop.config.common.annotation.AnnotationBuilder;
import org.springframework.data.hadoop.config.common.annotation.AnnotationConfigurer;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.PartitionDataStoreWriter;
import org.springframework.data.hadoop.store.config.annotation.EnableDataStorePartitionTextWriter;
import org.springframework.data.hadoop.store.config.annotation.EnableDataStoreTextWriter;
import org.springframework.data.hadoop.store.config.annotation.SpringDataStoreWriterConfigs;
import org.springframework.data.hadoop.store.config.annotation.builders.SpringDataStoreTextWriterBuilder;
import org.springframework.data.hadoop.store.output.AbstractDataStreamWriter;
import org.springframework.data.hadoop.store.output.AbstractPartitionDataStoreWriter;
import org.springframework.data.hadoop.store.output.PartitionTextFileWriter;
import org.springframework.data.hadoop.store.output.TextFileWriter;
import org.springframework.data.hadoop.store.partition.PartitionStrategy;
import org.springframework.data.hadoop.store.support.LifecycleObjectSupport;
import org.springframework.data.hadoop.store.support.OutputStoreObjectSupport;
import org.springframework.data.hadoop.store.support.StoreObjectSupport;
import org.springframework.util.ClassUtils;

@Configuration
public class SpringDataStoreTextWriterConfiguration
extends AbstractImportingAnnotationConfiguration<SpringDataStoreTextWriterBuilder, SpringDataStoreWriterConfigs> {
    private final SpringDataStoreTextWriterBuilder builder = new SpringDataStoreTextWriterBuilder();

    protected BeanDefinition buildBeanDefinition(AnnotationMetadata importingClassMetadata, Class<? extends Annotation> namedAnnotation) throws Exception {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(TextWriterDelegatingFactoryBean.class);
        beanDefinitionBuilder.addConstructorArgValue((Object)this.builder);
        if (namedAnnotation == EnableDataStorePartitionTextWriter.class) {
            beanDefinitionBuilder.addConstructorArgValue(PartitionDataStoreWriter.class);
        } else {
            beanDefinitionBuilder.addConstructorArgValue(DataStoreWriter.class);
        }
        beanDefinitionBuilder.addConstructorArgValue((Object)importingClassMetadata.getClassName());
        return beanDefinitionBuilder.getBeanDefinition();
    }

    protected List<Class<? extends Annotation>> getAnnotations() {
        ArrayList<Class<? extends Annotation>> types = new ArrayList<Class<? extends Annotation>>();
        types.add(EnableDataStoreTextWriter.class);
        types.add(EnableDataStorePartitionTextWriter.class);
        return types;
    }

    private static class TextWriterDelegatingFactoryBean
    extends AbstractImportingAnnotationConfiguration.BeanDelegatingFactoryBean<DataStoreWriter<?>, SpringDataStoreTextWriterBuilder, SpringDataStoreWriterConfigs>
    implements SmartLifecycle,
    Closeable {
        private String clazzName;
        @Autowired(required=false)
        @Qualifier(value="hadoopConfiguration")
        private org.apache.hadoop.conf.Configuration configuration;
        private LifecycleObjectSupport lifecycle;
        private Closeable closeable;

        public TextWriterDelegatingFactoryBean(SpringDataStoreTextWriterBuilder builder, Class<DataStoreWriter<?>> clazz, String clazzName) {
            super((AnnotationBuilder)builder, clazz);
            this.clazzName = clazzName;
        }

        public void afterPropertiesSet() throws Exception {
            LifecycleObjectSupport writer;
            for (AnnotationConfigurer configurer : this.getConfigurers()) {
                Class<?> clazz = configurer.getClass();
                if (!ClassUtils.getUserClass(clazz).getName().equals(this.clazzName)) continue;
                ((SpringDataStoreTextWriterBuilder)this.getBuilder()).apply(configurer);
            }
            SpringDataStoreWriterConfigs configs = (SpringDataStoreWriterConfigs)((SpringDataStoreTextWriterBuilder)this.getBuilder()).getOrBuild();
            if (configs.getPartitionStrategy() == null) {
                writer = new TextFileWriter(this.configuration != null ? this.configuration : configs.getConfiguration(), configs.getBasePath(), configs.getCodec());
                if (configs.getOverwrite() != null) {
                    ((OutputStoreObjectSupport)writer).setOverwrite(configs.getOverwrite());
                }
                if (configs.getAppendable() != null) {
                    ((OutputStoreObjectSupport)writer).setAppendable(configs.getAppendable());
                }
                if (configs.getInWritingPrefix() != null) {
                    ((OutputStoreObjectSupport)writer).setInWritingPrefix(configs.getInWritingPrefix());
                }
                if (configs.getInWritingSuffix() != null) {
                    ((OutputStoreObjectSupport)writer).setInWritingSuffix(configs.getInWritingSuffix());
                }
                if (configs.getIdleTimeout() != null) {
                    ((StoreObjectSupport)writer).setIdleTimeout(configs.getIdleTimeout());
                }
                if (configs.getCloseTimeout() != null) {
                    ((StoreObjectSupport)writer).setCloseTimeout(configs.getCloseTimeout());
                }
                if (configs.getFileOpenAttempts() != null) {
                    ((AbstractDataStreamWriter)writer).setMaxOpenAttempts(configs.getFileOpenAttempts());
                }
                if (configs.getFileNamingStrategy() != null) {
                    ((OutputStoreObjectSupport)writer).setFileNamingStrategy(configs.getFileNamingStrategy());
                }
                if (configs.getRolloverStrategy() != null) {
                    ((OutputStoreObjectSupport)writer).setRolloverStrategy(configs.getRolloverStrategy());
                }
                writer.setBeanFactory(this.getBeanFactory());
                writer.afterPropertiesSet();
                this.lifecycle = writer;
                this.closeable = writer;
                this.setObject(writer);
            } else {
                writer = new PartitionTextFileWriter(this.configuration != null ? this.configuration : configs.getConfiguration(), configs.getBasePath(), configs.getCodec(), (PartitionStrategy<String, ?>)configs.getPartitionStrategy());
                if (configs.getOverwrite() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setOverwrite(configs.getOverwrite());
                }
                if (configs.getAppendable() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setAppendable(configs.getAppendable());
                }
                if (configs.getInWritingPrefix() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setInWritingPrefix(configs.getInWritingPrefix());
                }
                if (configs.getInWritingSuffix() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setInWritingSuffix(configs.getInWritingSuffix());
                }
                if (configs.getIdleTimeout() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setIdleTimeout(configs.getIdleTimeout());
                }
                if (configs.getCloseTimeout() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setCloseTimeout(configs.getCloseTimeout());
                }
                if (configs.getFileOpenAttempts() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setMaxOpenAttempts(configs.getFileOpenAttempts());
                }
                if (configs.getFileNamingStrategy() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setFileNamingStrategyFactory(configs.getFileNamingStrategy());
                }
                if (configs.getRolloverStrategy() != null) {
                    ((AbstractPartitionDataStoreWriter)writer).setRolloverStrategyFactory(configs.getRolloverStrategy());
                }
                writer.setBeanFactory(this.getBeanFactory());
                writer.afterPropertiesSet();
                this.lifecycle = writer;
                this.closeable = writer;
                this.setObject(writer);
            }
        }

        public void start() {
            this.lifecycle.start();
        }

        public void stop() {
            this.lifecycle.stop();
        }

        public boolean isRunning() {
            return this.lifecycle.isRunning();
        }

        public int getPhase() {
            return this.lifecycle.getPhase();
        }

        public boolean isAutoStartup() {
            return this.lifecycle.isAutoStartup();
        }

        public void stop(Runnable callback) {
            this.lifecycle.stop(callback);
        }

        @Override
        public void close() throws IOException {
            this.closeable.close();
        }
    }
}

