/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.strategy.naming;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.strategy.naming.FileNamingStrategy;
import org.springframework.data.hadoop.store.support.OrderedComposite;

public class ChainedFileNamingStrategy
implements FileNamingStrategy {
    private final OrderedComposite<FileNamingStrategy> strategies = new OrderedComposite();

    public ChainedFileNamingStrategy() {
        this(Collections.emptyList());
    }

    public ChainedFileNamingStrategy(List<? extends FileNamingStrategy> strategies) {
        this.setStrategies(strategies);
    }

    @Override
    public Path resolve(Path path) {
        Iterator<FileNamingStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext()) {
            path = iterator.next().resolve(path);
        }
        return path;
    }

    @Override
    public void next() {
        Iterator<FileNamingStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext()) {
            iterator.next().next();
        }
    }

    @Override
    public void reset() {
        Iterator<FileNamingStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
        }
    }

    @Override
    public Path init(Path path) {
        Iterator<FileNamingStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext()) {
            path = iterator.next().init(path);
        }
        return path;
    }

    @Override
    public void setCodecInfo(CodecInfo codecInfo) {
        Iterator<FileNamingStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext()) {
            iterator.next().setCodecInfo(codecInfo);
        }
    }

    @Override
    public ChainedFileNamingStrategy createInstance() {
        ChainedFileNamingStrategy instance = new ChainedFileNamingStrategy();
        for (FileNamingStrategy strategy : this.strategies.getItems()) {
            instance.register((FileNamingStrategy)strategy.createInstance());
        }
        return instance;
    }

    public void setStrategies(List<? extends FileNamingStrategy> strategies) {
        this.strategies.setItems(strategies);
    }

    public void register(FileNamingStrategy strategy) {
        this.strategies.add(strategy);
    }

    public List<? extends FileNamingStrategy> getStrategies() {
        return this.strategies.getItems();
    }
}

