/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.event.FileWrittenEvent;
import org.springframework.data.hadoop.store.event.StoreEventPublisher;
import org.springframework.data.hadoop.store.output.AbstractDataStreamWriter;
import org.springframework.data.hadoop.store.support.OutputContext;
import org.springframework.data.hadoop.store.support.StreamsHolder;

public class OutputStreamWriter
extends AbstractDataStreamWriter
implements DataStoreWriter<byte[]> {
    private static final Log log = LogFactory.getLog(OutputStreamWriter.class);
    private StreamsHolder<OutputStream> streamsHolder;

    public OutputStreamWriter(Configuration configuration, Path basePath, CodecInfo codec) {
        super(configuration, basePath, codec);
    }

    @Override
    public void flush() throws IOException {
        if (this.streamsHolder != null) {
            this.streamsHolder.getStream().flush();
        }
    }

    public synchronized void hflush() throws IOException {
        if (this.streamsHolder != null) {
            ((Syncable)this.streamsHolder.getStream()).hflush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.streamsHolder != null) {
            this.streamsHolder.close();
            Path path = this.renameFile(this.streamsHolder.getPath());
            StoreEventPublisher storeEventPublisher = this.getStoreEventPublisher();
            if (storeEventPublisher != null) {
                storeEventPublisher.publishEvent(new FileWrittenEvent(this, path));
            }
            this.streamsHolder = null;
        }
    }

    @Override
    public synchronized void write(byte[] entity) throws IOException {
        if (this.streamsHolder == null) {
            this.streamsHolder = this.getOutput();
        }
        OutputStream out = this.streamsHolder.getStream();
        out.write(entity);
        this.setWritePosition(this.getPosition(this.streamsHolder));
        OutputContext context = this.getOutputContext();
        if (context.getRolloverState()) {
            log.info((Object)"after write, rollever state is true");
            this.close();
            context.rollStrategies();
        }
    }

    @Override
    protected void handleIdleTimeout() {
        try {
            if (this.isAppendable()) {
                log.info((Object)"Idle timeout detected for this writer, flushing stream");
                this.hflush();
            } else {
                log.info((Object)"Idle timeout detected for this writer, closing stream");
                this.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"error closing", (Throwable)e);
        }
        this.getOutputContext().rollStrategies();
    }
}

