/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.output;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.output.TextFileWriter;
import org.springframework.data.hadoop.store.support.StoreUtils;

public class DelimitedTextFileWriter
implements DataStoreWriter<List<String>> {
    public static final byte[] CSV = StoreUtils.getUTF8CsvDelimiter();
    public static final byte[] TAB = StoreUtils.getUTF8TabDelimiter();
    private TextFileWriter textFileWriter;
    private final String fieldDelimiter;

    public DelimitedTextFileWriter(Configuration configuration, Path basePath, CodecInfo codec) {
        this(configuration, basePath, codec, CSV);
    }

    public DelimitedTextFileWriter(Configuration configuration, Path basePath, CodecInfo codec, byte[] fieldDelimiter) {
        this.fieldDelimiter = new String(fieldDelimiter);
        this.textFileWriter = new TextFileWriter(configuration, basePath, codec);
    }

    public DelimitedTextFileWriter(Configuration configuration, Path basePath, CodecInfo codec, byte[] fieldDelimiter, byte[] textDelimiter) {
        this.fieldDelimiter = new String(fieldDelimiter);
        this.textFileWriter = new TextFileWriter(configuration, basePath, codec, textDelimiter);
    }

    @Override
    public void write(List<String> entity) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < entity.size(); ++i) {
            buf.append(entity.get(i));
            if (i >= entity.size() - 1) continue;
            buf.append(this.fieldDelimiter);
        }
        this.textFileWriter.write(buf.toString());
    }

    @Override
    public void flush() throws IOException {
        this.textFileWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.textFileWriter.close();
    }
}

