/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;

public class PathCombiningMethodExecutor
implements MethodExecutor {
    private static final String PATH_DELIMITER = "/";

    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        return new TypedValue((Object)PathCombiningMethodExecutor.pathWithObjectArray(arguments));
    }

    public static String path(String arg) throws AccessException {
        return PathCombiningMethodExecutor.pathWithObjectArray(new String[]{arg});
    }

    public static String path(String ... arguments) throws AccessException {
        return PathCombiningMethodExecutor.pathWithObjectArray(arguments);
    }

    public static String path(Long arg) throws AccessException {
        return PathCombiningMethodExecutor.pathWithObjectArray(new Long[]{arg});
    }

    public static String path(Long ... arguments) throws AccessException {
        return PathCombiningMethodExecutor.pathWithObjectArray(arguments);
    }

    public static String path(Object arg) throws AccessException {
        return PathCombiningMethodExecutor.pathWithObjectArray(new Object[]{arg});
    }

    public static String path(Object ... arguments) throws AccessException {
        return PathCombiningMethodExecutor.pathWithObjectArray(arguments);
    }

    private static String pathWithObjectArray(Object[] arguments) throws AccessException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            buf.append(arguments[i]);
            if (i + 1 >= arguments.length) continue;
            buf.append(PATH_DELIMITER);
        }
        return buf.toString();
    }
}

