/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import org.springframework.asm.MethodVisitor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.CompilablePropertyAccessor;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.messaging.Message;

public class MessagePartitionKeyPropertyAccessor
extends ReflectivePropertyAccessor {
    private static final Class<?>[] CLASSES = new Class[]{Message.class};
    private static final String PAYLOAD = "payload";
    private static final String HEADERS = "headers";
    private static final String TIMESTAMP = "timestamp";
    private static final String messageClassDescriptor = "org/springframework/messaging/Message";
    private static final String messageHeadersClassDescriptor = "org/springframework/messaging/MessageHeaders";
    private volatile String typeDescriptor;

    public Class<?>[] getSpecificTargetClasses() {
        return CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        if (target instanceof Message && !PAYLOAD.equals(name) && !HEADERS.equals(name)) {
            boolean containsKey = ((Message)target).getHeaders().containsKey((Object)name);
            if (containsKey) {
                this.typeDescriptor = CodeFlow.toDescriptorFromObject((Object)((Message)target).getHeaders().get((Object)name));
            }
            return containsKey;
        }
        return super.canRead(context, target, name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        if (target instanceof Message) {
            if (PAYLOAD.equals(name) || HEADERS.equals(name)) {
                return super.read(context, target, name);
            }
            return super.read(context, (Object)((Message)target).getHeaders(), name);
        }
        return super.read(context, target, name);
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return super.canWrite(context, target, name);
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        super.write(context, target, name, newValue);
    }

    public PropertyAccessor createOptimalAccessor(EvaluationContext evalContext, Object target, String name) {
        if (target instanceof Message && !PAYLOAD.equals(name) && !HEADERS.equals(name)) {
            return new MessageOptimalPropertyAccessor(this.typeDescriptor);
        }
        return super.createOptimalAccessor(evalContext, target, name);
    }

    public static class MessageOptimalPropertyAccessor
    implements CompilablePropertyAccessor {
        private final String typeDescriptor;

        public MessageOptimalPropertyAccessor(String typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        public Class<?>[] getSpecificTargetClasses() {
            throw new UnsupportedOperationException("Should not be called on an MessageOptimalPropertyAccessor");
        }

        public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
            return true;
        }

        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            return new TypedValue(((Message)target).getHeaders().get((Object)name));
        }

        public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
            throw new UnsupportedOperationException("Should not be called on an MessageOptimalPropertyAccessor");
        }

        public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
            throw new UnsupportedOperationException("Should not be called on an MessageOptimalPropertyAccessor");
        }

        public boolean isCompilable() {
            return true;
        }

        public Class<?> getPropertyType() {
            return Object.class;
        }

        public void generateCode(String propertyName, MethodVisitor mv, CodeFlow cf) {
            String descriptor = cf.lastDescriptor();
            if (descriptor == null) {
                cf.loadTarget(mv);
            }
            if (descriptor == null || !MessagePartitionKeyPropertyAccessor.messageClassDescriptor.equals(descriptor.substring(1))) {
                mv.visitTypeInsn(192, MessagePartitionKeyPropertyAccessor.messageClassDescriptor);
            }
            mv.visitMethodInsn(185, MessagePartitionKeyPropertyAccessor.messageClassDescriptor, "getHeaders", "()Lorg/springframework/messaging/MessageHeaders;", true);
            if (MessagePartitionKeyPropertyAccessor.TIMESTAMP.equals(propertyName)) {
                mv.visitMethodInsn(182, MessagePartitionKeyPropertyAccessor.messageHeadersClassDescriptor, "getTimestamp", "()Ljava/lang/Long;", false);
            } else {
                mv.visitLdcInsn((Object)propertyName);
                mv.visitMethodInsn(182, MessagePartitionKeyPropertyAccessor.messageHeadersClassDescriptor, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
            }
            if (this.typeDescriptor != null) {
                CodeFlow.insertCheckCast((MethodVisitor)mv, (String)this.typeDescriptor);
            }
        }
    }
}

