/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import java.util.Map;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.CompilablePropertyAccessor;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;

public class MapPartitionKeyPropertyAccessor
extends ReflectivePropertyAccessor {
    private static final Class<?>[] CLASSES = new Class[]{Map.class};
    private static final String mapClassDescriptor = "java/util/Map";
    private volatile String typeDescriptor;

    public Class<?>[] getSpecificTargetClasses() {
        return CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        boolean containsKey = ((Map)target).containsKey(name);
        if (containsKey) {
            this.typeDescriptor = CodeFlow.toDescriptorFromObject(((Map)target).get(name));
        }
        return containsKey;
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        Map map = (Map)target;
        Object value = map.get(name);
        if (value == null && !map.containsKey(name)) {
            throw new MapAccessException(name);
        }
        return new TypedValue(value);
    }

    public PropertyAccessor createOptimalAccessor(EvaluationContext evalContext, Object target, String name) {
        return new MapOptimalPropertyAccessor(this.typeDescriptor);
    }

    private static class MapAccessException
    extends AccessException {
        private final String key;

        public MapAccessException(String key) {
            super(null);
            this.key = key;
        }

        public String getMessage() {
            return "Map does not contain a value for key '" + this.key + "'";
        }
    }

    public static class MapOptimalPropertyAccessor
    implements CompilablePropertyAccessor {
        private final String typeDescriptor;

        public MapOptimalPropertyAccessor(String typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        public Class<?>[] getSpecificTargetClasses() {
            throw new UnsupportedOperationException("Should not be called on an MessageOptimalPropertyAccessor");
        }

        public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
            return true;
        }

        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            return new TypedValue(((Map)target).get(name));
        }

        public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
            throw new UnsupportedOperationException("Should not be called on an MessageOptimalPropertyAccessor");
        }

        public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
            throw new UnsupportedOperationException("Should not be called on an MessageOptimalPropertyAccessor");
        }

        public boolean isCompilable() {
            return true;
        }

        public Class<?> getPropertyType() {
            return Object.class;
        }

        public void generateCode(String propertyName, MethodVisitor mv, CodeFlow cf) {
            String descriptor = cf.lastDescriptor();
            if (descriptor == null) {
                cf.loadTarget(mv);
            }
            if (descriptor == null || !MapPartitionKeyPropertyAccessor.mapClassDescriptor.equals(descriptor.substring(1))) {
                mv.visitTypeInsn(192, MapPartitionKeyPropertyAccessor.mapClassDescriptor);
            }
            mv.visitLdcInsn((Object)propertyName);
            mv.visitMethodInsn(185, MapPartitionKeyPropertyAccessor.mapClassDescriptor, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            if (this.typeDescriptor != null) {
                CodeFlow.insertCheckCast((MethodVisitor)mv, (String)this.typeDescriptor);
            }
        }
    }
}

