/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetReader;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.hadoop.store.dataset.AbstractDatasetStoreReader;
import org.springframework.data.hadoop.store.dataset.DatasetDefinition;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryFactory;
import org.springframework.data.hadoop.store.dataset.DatasetUtils;

public class ParquetDatasetStoreReader<T>
extends AbstractDatasetStoreReader<T, GenericRecord> {
    protected volatile Schema schema;

    public ParquetDatasetStoreReader(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory, DatasetDefinition datasetDefinition) {
        super(entityClass, datasetRepositoryFactory, datasetDefinition);
    }

    @Override
    protected DatasetReader<GenericRecord> createReader() {
        Dataset<GenericRecord> dataset = DatasetUtils.getOrCreateDataset(this.getDatasetRepositoryFactory(), this.getDatasetDefinition(), this.getEntityClass(), GenericRecord.class);
        this.schema = dataset.getDescriptor().getSchema();
        return dataset.newReader();
    }

    @Override
    protected T convertEntity(GenericRecord entity) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(this.getEntityClass());
        for (Schema.Field f : this.schema.getFields()) {
            if (!beanWrapper.isWritableProperty(f.name())) continue;
            beanWrapper.setPropertyValue(f.name(), entity.get(f.name()));
        }
        return (T)beanWrapper.getWrappedInstance();
    }
}

