/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionStrategy;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.util.Assert;

public class DatasetDefinition {
    private Class<?> targetClass;
    private boolean allowNullValues;
    private Format format;
    private PartitionStrategy partitionStrategy;
    private Integer writerCacheSize;
    private CompressionType compressionType;
    private Schema schema;

    public DatasetDefinition() {
        this(null, true, Formats.AVRO.getName());
    }

    public DatasetDefinition(boolean allowNullValues) {
        this(null, allowNullValues, Formats.AVRO.getName());
    }

    public DatasetDefinition(boolean allowNullValues, String format) {
        this(null, allowNullValues, format);
    }

    public DatasetDefinition(Class<?> targetClass, boolean allowNullValues, String format) {
        this.setTargetClass(targetClass);
        this.setAllowNullValues(allowNullValues);
        this.setFormat(format);
    }

    public DatasetDefinition(Class<?> targetClass, PartitionStrategy partitionStrategy) {
        this(targetClass, Formats.AVRO.getName(), partitionStrategy);
    }

    public DatasetDefinition(Class<?> targetClass, String format, PartitionStrategy partitionStrategy) {
        this.setTargetClass(targetClass);
        this.setAllowNullValues(false);
        this.setFormat(format);
        this.setPartitionStrategy(partitionStrategy);
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public void setFormat(String format) {
        Assert.notNull((Object)format, (String)"The format can't be null");
        try {
            this.format = Formats.fromString((String)format);
        }
        catch (IllegalArgumentException e) {
            throw new StoreException("Invalid format '" + format + "' specified", e);
        }
    }

    public void setPartitionStrategy(PartitionStrategy partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public void setWriterCacheSize(Integer writerCacheSize) {
        this.writerCacheSize = writerCacheSize;
    }

    public void setCompressionType(String compressionType) {
        Assert.notNull((Object)compressionType, (String)"The compression type can't be null");
        try {
            this.compressionType = CompressionType.forName((String)compressionType);
        }
        catch (IllegalArgumentException e) {
            throw new StoreException("Invalid compression type '" + compressionType + "' specified", e);
        }
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public Format getFormat() {
        return this.format;
    }

    public PartitionStrategy getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public Integer getWriterCacheSize() {
        return this.writerCacheSize;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public Schema getSchema(Class<?> datasetClass) {
        if (this.schema != null) {
            return this.schema;
        }
        Schema s = this.allowNullValues ? ReflectData.AllowNull.get().getSchema(datasetClass) : ReflectData.get().getSchema(datasetClass);
        return s;
    }
}

