/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.hadoop.store.config.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.hadoop.config.common.annotation.EnableAnnotationConfiguration;
import org.springframework.data.hadoop.config.common.annotation.configuration.ObjectPostProcessorConfiguration;
import org.springframework.data.hadoop.store.config.annotation.configuration.SpringDataStoreTextWriterConfiguration;

/**
 * Enable store text file writer features.
 *
 * @author Janne Valkealahti
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
@EnableAnnotationConfiguration
@Import({SpringDataStoreTextWriterConfiguration.class, ObjectPostProcessorConfiguration.class})
public @interface EnableDataStoreTextWriter {

	/**
	 * The name of bean, or if plural, aliases for bean created based on this
	 * annotation. If left unspecified bean name will be autogenerated.
	 *
	 * @see Bean#name()
	 * @return the array if names or empty as default
	 */
	String[] name() default {};

}
