/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.batch.spark;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SparkYarnTasklet
implements InitializingBean,
Tasklet,
StepExecutionListener {
    private boolean complete = false;
    private String sparkAssemblyJar;
    private Configuration hadoopConfiguration;
    private String appName;
    private String appClass;
    private String appJar;
    private String resourceFiles;
    private String resourceArchives;
    private String executorMemory;
    private int numExecutors;
    private String[] arguments;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        SparkConf sparkConf = new SparkConf();
        sparkConf.set("spark.yarn.jar", this.sparkAssemblyJar);
        ArrayList<String> submitArgs = new ArrayList<String>();
        if (StringUtils.hasText((String)this.appName)) {
            submitArgs.add("--name");
            submitArgs.add(this.appName);
        }
        submitArgs.add("--jar");
        submitArgs.add(this.appJar);
        submitArgs.add("--class");
        submitArgs.add(this.appClass);
        if (StringUtils.hasText((String)this.resourceFiles)) {
            submitArgs.add("--files");
            submitArgs.add(this.resourceFiles);
        }
        if (StringUtils.hasText((String)this.resourceArchives)) {
            submitArgs.add("--archives");
            submitArgs.add(this.resourceArchives);
        }
        submitArgs.add("--executor-memory");
        submitArgs.add(this.executorMemory);
        submitArgs.add("--num-executors");
        submitArgs.add("" + this.numExecutors);
        for (String arg : this.arguments) {
            submitArgs.add("--arg");
            submitArgs.add(arg);
        }
        ClientArguments clientArguments = new ClientArguments(submitArgs.toArray(new String[submitArgs.size()]), sparkConf);
        Client client = new Client(clientArguments, this.hadoopConfiguration, sparkConf);
        System.setProperty("SPARK_YARN_MODE", "true");
        client.run();
        this.complete = true;
        return RepeatStatus.FINISHED;
    }

    public void beforeStep(StepExecution stepExecution) {
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        if (this.complete) {
            return ExitStatus.COMPLETED;
        }
        return ExitStatus.FAILED;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.sparkAssemblyJar, (String)"sparkAssemblyJar property was not set. You must specify the path for the spark-assembly jar file. It can either be a local file or stored in HDFS using an 'hdfs://' prefix.");
        Assert.notNull((Object)this.hadoopConfiguration, (String)"hadoopConfiguration property was not set. You must provide a reference to the Hadoop configuration to be used.");
        Assert.hasText((String)this.appClass, (String)"appClass property was not set. You must specify the main class of the application to execute.");
        Assert.hasText((String)this.appJar, (String)"appJar property was not set.You must specify the path to the jar that contains the app to execute.");
        if (!StringUtils.hasText((String)this.executorMemory)) {
            this.executorMemory = "1G";
        }
        if (this.numExecutors == 0) {
            this.numExecutors = 1;
        }
    }

    public void setSparkAssemblyJar(String sparkAssemblyJar) {
        this.sparkAssemblyJar = sparkAssemblyJar;
    }

    public void setHadoopConfiguration(Configuration configuration) {
        this.hadoopConfiguration = configuration;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setAppClass(String appClass) {
        this.appClass = appClass;
    }

    public void setAppJar(String appJar) {
        this.appJar = appJar;
    }

    public void setResourceFiles(String resourceFiles) {
        this.resourceFiles = resourceFiles;
    }

    public void setResourceArchives(String resourceArchives) {
        this.resourceArchives = resourceArchives;
    }

    public void setExecutorMemory(String executorMemory) {
        this.executorMemory = executorMemory;
    }

    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }
}

