/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hive.service.Service;
import org.apache.hive.service.server.HiveServer2;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;

public class HiveServerFactoryBean
implements FactoryBean<HiveServer2>,
InitializingBean,
DisposableBean,
SmartLifecycle {
    private boolean autoStartup = true;
    private HiveServer2 server;
    private String host = "localhost";
    private int port = 10000;
    private int minThreads = 10;
    private int maxThreads = 100;
    private Configuration configuration;
    private Properties properties;
    private HiveConf hiveConf;

    public void destroy() {
        this.stop();
        CommandProcessorFactory.clean((HiveConf)this.hiveConf);
        this.server = null;
    }

    public void afterPropertiesSet() throws Exception {
        Configuration cfg = ConfigurationUtils.createFrom((Configuration)this.configuration, (Properties)this.properties);
        this.hiveConf = new HiveConf(cfg, HiveServer2.class);
        this.hiveConf.set("hive.server2.thrift.bind.host", this.host);
        this.hiveConf.set("hive.server2.thrift.port", String.valueOf(this.port));
        this.hiveConf.set("hive.server2.thrift.min.worker.threads", String.valueOf(this.minThreads));
        this.hiveConf.set("hive.server2.thrift.max.worker.threads", String.valueOf(this.maxThreads));
        ServerUtils.cleanUpScratchDir((HiveConf)this.hiveConf);
        this.server = new HiveServer2();
        this.server.init(this.hiveConf);
        if (this.autoStartup) {
            this.server.start();
        }
    }

    public HiveServer2 getObject() {
        return this.server;
    }

    public Class<?> getObjectType() {
        return this.server != null ? this.server.getClass() : HiveServer2.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() {
        if (!this.isRunning()) {
            this.server.start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.server.stop();
        }
    }

    public boolean isRunning() {
        return this.server != null && this.server.getServiceState().equals((Object)Service.STATE.STARTED);
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

