/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class ArrayUtils {
    @SafeVarargs
    public static <T> T[] asArray(T ... elements) {
        return elements;
    }

    @Nullable
    public static <T> T[] defaultIfEmpty(@Nullable T[] array, @Nullable T[] defaultArray) {
        return ArrayUtils.isNotEmpty(array) ? array : defaultArray;
    }

    @Nullable
    public static <T> T getFirst(@Nullable T[] array) {
        return ArrayUtils.getFirst(array, null);
    }

    @Nullable
    public static <T> T getFirst(@Nullable T[] array, @Nullable T defaultValue) {
        return ArrayUtils.isEmpty(array) ? defaultValue : array[0];
    }

    @NonNull
    public static Object[] insert(@NonNull Object[] originalArray, int position, Object element) {
        Object[] newArray = (Object[])Array.newInstance(originalArray.getClass().getComponentType(), originalArray.length + 1);
        if (position > 0) {
            System.arraycopy(originalArray, 0, newArray, 0, position);
        }
        newArray[position] = element;
        if (position < originalArray.length) {
            System.arraycopy(originalArray, position, newArray, position + 1, originalArray.length - position);
        }
        return newArray;
    }

    public static boolean isEmpty(@Nullable Object[] array) {
        return ArrayUtils.length(array) == 0;
    }

    public static boolean isNotEmpty(@Nullable Object[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static int length(@Nullable Object[] array) {
        return array != null ? array.length : 0;
    }

    public static <T> T[] nullSafeArray(@Nullable T[] array, @NonNull Class<T> componentType) {
        return array != null ? array : (Object[])Array.newInstance(componentType, 0);
    }

    public static Object[] remove(@NonNull Object[] originalArray, int position) {
        Object[] newArray = (Object[])Array.newInstance(originalArray.getClass().getComponentType(), originalArray.length - 1);
        if (position > 0) {
            System.arraycopy(originalArray, 0, newArray, 0, position);
        }
        if (position < originalArray.length - 1) {
            System.arraycopy(originalArray, position + 1, newArray, position, originalArray.length - 1 - position);
        }
        return newArray;
    }

    @NonNull
    public static <T extends Comparable<T>> T[] sort(@NonNull T[] array) {
        Arrays.sort(array);
        return array;
    }

    @NonNull
    public static <T> Iterable<T> toIterable(T ... array) {
        return IterableArray.of(array);
    }

    protected static class IterableArray<T>
    implements Iterable<T> {
        private final T[] array;

        protected static <T> IterableArray<T> of(T ... array) {
            return new IterableArray<T>(array);
        }

        protected IterableArray(@NonNull T[] array) {
            Assert.notNull(array, (String)"Array must not be null");
            this.array = array;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public T next() {
                    return array[this.index++];
                }
            };
        }
    }
}

