/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableGatewaySenders;
import org.springframework.data.gemfire.config.annotation.GatewaySenderConfiguration;
import org.springframework.data.gemfire.util.ArrayUtils;

@Configuration
public class GatewaySendersConfiguration
extends GatewaySenderConfiguration {
    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableGatewaySenders.class;
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(annotationMetadata)) {
            AnnotationAttributes parentGatewaySendersAnnotation = this.getAnnotationAttributes(annotationMetadata);
            this.registerGatewaySenders(parentGatewaySendersAnnotation, registry);
        }
    }

    private void registerGatewaySenders(AnnotationAttributes parentGatewaySendersAnnotation, BeanDefinitionRegistry registry) {
        Object[] gatewaySenderAnnotations = parentGatewaySendersAnnotation.getAnnotationArray("gatewaySenders");
        if (ArrayUtils.isNotEmpty(gatewaySenderAnnotations)) {
            for (Object gatewaySenderAnnotation : gatewaySenderAnnotations) {
                this.registerGatewaySender((AnnotationAttributes)gatewaySenderAnnotation, parentGatewaySendersAnnotation, registry);
            }
        } else {
            this.registerDefaultGatewaySender(parentGatewaySendersAnnotation, registry);
        }
    }

    private void registerDefaultGatewaySender(AnnotationAttributes parentGatewaySendersAnnotation, BeanDefinitionRegistry registry) {
        this.registerGatewaySender("GatewaySender", parentGatewaySendersAnnotation, parentGatewaySendersAnnotation, registry);
    }
}

