/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client.support;

import java.util.Optional;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.springframework.data.gemfire.CacheResolver;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ClientCacheDefaultPoolResolver
implements PoolResolver {
    private final CacheResolver<ClientCache> clientCacheResolver;

    public ClientCacheDefaultPoolResolver(@NonNull CacheResolver<ClientCache> clientCacheResolver) {
        Assert.notNull(clientCacheResolver, (String)"CacheResolver for ClientCache must not be null");
        this.clientCacheResolver = clientCacheResolver;
    }

    @NonNull
    protected CacheResolver<ClientCache> getClientCacheResolver() {
        return this.clientCacheResolver;
    }

    @Override
    @Nullable
    public Pool resolve(@Nullable String poolName) {
        return Optional.of(this.getClientCacheResolver()).filter(it -> "DEFAULT".equals(poolName)).map(CacheResolver::resolve).map(ClientCache::getDefaultPool).orElse(null);
    }
}

