/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Optional;
import java.util.function.Function;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringExtensions;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ResolvableRegionFactoryBean<K, V>
extends AbstractFactoryBeanSupport<Region<K, V>>
implements InitializingBean {
    private Boolean lookupEnabled = false;
    private GemFireCache cache;
    private Region<?, ?> parent;
    private Resource snapshot;
    private volatile Region<K, V> region;
    private String name;
    private String regionName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        GemFireCache cache = this.requireCache();
        String regionName = this.requireRegionName();
        GemFireCache gemFireCache = cache;
        synchronized (gemFireCache) {
            this.setRegion(this.isLookupEnabled() ? Optional.ofNullable(this.getParent()).map(parentRegion -> parentRegion.getSubregion(regionName)).orElseGet(() -> cache.getRegion(regionName)) : null);
            if (this.getRegion() != null) {
                this.logInfo("Found Region [%1$s] in Cache [%2$s]", regionName, cache.getName());
            } else {
                this.logInfo("Falling back to creating Region [%1$s] in Cache [%2$s]", regionName, cache.getName());
                this.setRegion(this.postProcess(this.loadSnapshot(this.createRegion(cache, regionName))));
            }
        }
    }

    private GemFireCache requireCache() {
        GemFireCache cache = this.getCache();
        Assert.notNull((Object)cache, (String)"Cache is required");
        return cache;
    }

    private String requireRegionName() {
        String regionName = this.resolveRegionName();
        Assert.hasText((String)regionName, (String)"regionName, name or the beanName property must be set");
        return regionName;
    }

    public String resolveRegionName() {
        return StringUtils.hasText((String)this.regionName) ? this.regionName : (StringUtils.hasText((String)this.name) ? this.name : this.getBeanName());
    }

    protected Region<K, V> createRegion(GemFireCache cache, String regionName) throws Exception {
        throw new BeanInitializationException(String.format("Region [%1$s] in Cache [%2$s] not found", regionName, cache));
    }

    @NonNull
    protected Region<K, V> loadSnapshot(@NonNull Region<K, V> region) {
        Resource snapshot = this.snapshot;
        if (snapshot != null) {
            SpringExtensions.VoidReturningThrowableOperation operation = () -> region.loadSnapshot(snapshot.getInputStream());
            Function<Throwable, RuntimeException> exceptionHandler = cause -> RuntimeExceptionFactory.newRuntimeException(cause, "Failed to load snapshot [%s]", snapshot);
            SpringExtensions.safeRunOperation(operation, exceptionHandler);
        }
        return region;
    }

    protected Region<K, V> postProcess(Region<K, V> region) {
        return region;
    }

    public Region<K, V> getObject() throws Exception {
        return this.getRegion();
    }

    public Class<?> getObjectType() {
        return Optional.ofNullable(this.getRegion()).map(Object::getClass).orElse(Region.class);
    }

    public GemFireCache getCache() {
        return this.cache;
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public boolean isLookupEnabled() {
        return Boolean.TRUE.equals(this.getLookupEnabled());
    }

    public void setLookupEnabled(Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
    }

    public Boolean getLookupEnabled() {
        return this.lookupEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(Region<?, ?> parent) {
        this.parent = parent;
    }

    protected Region<?, ?> getParent() {
        return this.parent;
    }

    protected void setRegion(Region<K, V> region) {
        this.region = region;
    }

    public Region<K, V> getRegion() {
        return this.region;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setSnapshot(Resource snapshot) {
        this.snapshot = snapshot;
    }
}

