/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.LocatorFactoryBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.AbstractCacheConfiguration;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.LocatorConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class EmbeddedServiceConfigurationSupport
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    public static final Integer DEFAULT_PORT = 0;
    public static final String DEFAULT_HOST = "localhost";
    @Autowired(required=false)
    private AbstractCacheConfiguration cacheConfiguration;

    @NonNull
    protected <T extends AbstractCacheConfiguration> T getCacheConfiguration() {
        return (T)Optional.ofNullable(this.cacheConfiguration).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("AbstractCacheConfiguration is required", new Object[0]));
    }

    public final void registerBeanDefinitions(@NonNull AnnotationMetadata importingClassMetadata, @NonNull BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes annotationAttributes = this.getAnnotationAttributes(importingClassMetadata);
            this.registerBeanDefinitions(importingClassMetadata, annotationAttributes, registry);
            this.setGemFireProperties(importingClassMetadata, annotationAttributes, registry);
        }
    }

    protected void registerBeanDefinitions(@NonNull AnnotationMetadata importingClassMetadata, @NonNull AnnotationAttributes annotationAttributes, @NonNull BeanDefinitionRegistry registry) {
        this.registerBeanDefinitions(importingClassMetadata, (Map<String, Object>)annotationAttributes, registry);
    }

    protected void registerBeanDefinitions(@NonNull AnnotationMetadata importingClassMetadata, @NonNull Map<String, Object> annotationAttributes, @NonNull BeanDefinitionRegistry registry) {
    }

    protected void setGemFireProperties(@NonNull AnnotationMetadata importingClassMetadata, @NonNull AnnotationAttributes annotationAttributes, @NonNull BeanDefinitionRegistry registry) {
        Properties gemfireProperties = this.toGemFireProperties((Map<String, Object>)annotationAttributes);
        if (this.hasProperties(gemfireProperties)) {
            try {
                ((AbstractCacheConfiguration)this.getCacheConfiguration()).add(gemfireProperties);
            }
            catch (Exception ignore) {
                this.registerGemFirePropertiesConfigurer(registry, gemfireProperties);
            }
        }
    }

    @Nullable
    protected abstract Properties toGemFireProperties(@NonNull Map<String, Object> var1);

    protected boolean hasProperties(@Nullable Properties properties) {
        return !CollectionUtils.isEmpty((Map)properties);
    }

    protected void registerGemFirePropertiesBeanPostProcessor(@NonNull BeanDefinitionRegistry registry, Properties gemFireProperties) {
        this.registerBeanDefinition(registry, GemFirePropertiesBeanPostProcessor.class, gemFireProperties);
    }

    protected void registerGemFirePropertiesConfigurer(@NonNull BeanDefinitionRegistry registry, Properties gemfireProperties) {
        this.registerClientGemFirePropertiesConfigurer(registry, gemfireProperties);
        this.registerLocatorGemFirePropertiesConfigurer(registry, gemfireProperties);
        this.registerPeerGemFirePropertiesConfigurer(registry, gemfireProperties);
    }

    private void registerBeanDefinition(@NonNull BeanDefinitionRegistry registry, @NonNull Class<?> beanType, @NonNull Properties gemfireProperties) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(beanType);
        builder.addConstructorArgValue((Object)gemfireProperties);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)this.newBeanDefinitionHolder(builder), (BeanDefinitionRegistry)registry);
    }

    protected void registerClientGemFirePropertiesConfigurer(BeanDefinitionRegistry registry, Properties gemfireProperties) {
        this.registerBeanDefinition(registry, ClientGemFirePropertiesConfigurer.class, gemfireProperties);
    }

    protected void registerLocatorGemFirePropertiesConfigurer(BeanDefinitionRegistry registry, Properties gemfireProperties) {
        this.registerBeanDefinition(registry, LocatorGemFirePropertiesConfigurer.class, gemfireProperties);
    }

    protected void registerPeerGemFirePropertiesConfigurer(BeanDefinitionRegistry registry, Properties gemfireProperties) {
        this.registerBeanDefinition(registry, PeerGemFirePropertiesConfigurer.class, gemfireProperties);
    }

    protected BeanDefinitionHolder newBeanDefinitionHolder(BeanDefinitionBuilder builder) {
        String beanName = this.generateBeanName(builder.getRawBeanDefinition().getBeanClass().getSimpleName());
        return new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), beanName);
    }

    protected String generateBeanName() {
        return this.generateBeanName(this.getAnnotationType());
    }

    protected String generateBeanName(Class<?> typeQualifier) {
        return this.generateBeanName(typeQualifier.getSimpleName());
    }

    protected String generateBeanName(String nameQualifier) {
        return String.format("%1$s.%2$s", this.getClass().getName(), nameQualifier);
    }

    protected <T> T resolveBean(Class<T> beanType) {
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            AutowireCapableBeanFactory autowiringBeanFactory = (AutowireCapableBeanFactory)beanFactory;
            NamedBeanHolder beanHolder = autowiringBeanFactory.resolveNamedBean(beanType);
            return (T)autowiringBeanFactory.configureBean(beanHolder.getBeanInstance(), beanHolder.getBeanName());
        }
        return (T)beanFactory.getBean(beanType);
    }

    @Nullable
    protected String resolveHost(@Nullable String hostname) {
        return this.resolveHost(hostname, DEFAULT_HOST);
    }

    @Nullable
    protected String resolveHost(@Nullable String hostname, @Nullable String defaultHostname) {
        return StringUtils.hasText((String)hostname) ? hostname : defaultHostname;
    }

    @Nullable
    protected Integer resolvePort(@Nullable Integer port) {
        return this.resolvePort(port, DEFAULT_PORT);
    }

    @Nullable
    protected Integer resolvePort(@Nullable Integer port, @Nullable Integer defaultPort) {
        return port != null ? port : defaultPort;
    }

    protected static class GemFirePropertiesBeanPostProcessor
    implements BeanPostProcessor {
        protected static final String GEMFIRE_PROPERTIES_BEAN_NAME = "gemfireProperties";
        private final Properties gemfireProperties;

        protected GemFirePropertiesBeanPostProcessor(@NonNull Properties gemfireProperties) {
            Assert.notEmpty((Map)gemfireProperties, (String)"GemFire Properties must not be null");
            this.gemfireProperties = gemfireProperties;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof Properties && GEMFIRE_PROPERTIES_BEAN_NAME.equals(beanName)) {
                Properties gemfirePropertiesBean = (Properties)bean;
                gemfirePropertiesBean.putAll((Map<?, ?>)this.gemfireProperties);
            }
            return bean;
        }
    }

    protected static class PeerGemFirePropertiesConfigurer
    extends AbstractGemFirePropertiesConfigurer
    implements PeerCacheConfigurer {
        protected PeerGemFirePropertiesConfigurer(@NonNull Properties gemfireProperties) {
            super(gemfireProperties);
        }

        @Override
        public void configure(@Nullable String beanName, @NonNull CacheFactoryBean bean) {
            this.configureGemFireProperties(bean);
        }
    }

    protected static class LocatorGemFirePropertiesConfigurer
    implements LocatorConfigurer {
        private final Properties gemfireProperties;

        public LocatorGemFirePropertiesConfigurer(@NonNull Properties gemfireProperties) {
            Assert.notEmpty((Map)gemfireProperties, (String)"GemFire Properties must not be null");
            this.gemfireProperties = gemfireProperties;
        }

        @Override
        public void configure(@Nullable String beanName, @NonNull LocatorFactoryBean bean) {
            Properties gemfireProperties = bean.getGemFireProperties();
            gemfireProperties.putAll((Map<?, ?>)this.gemfireProperties);
            bean.setGemFireProperties(gemfireProperties);
        }
    }

    protected static class ClientGemFirePropertiesConfigurer
    extends AbstractGemFirePropertiesConfigurer
    implements ClientCacheConfigurer {
        protected ClientGemFirePropertiesConfigurer(@NonNull Properties gemfireProperties) {
            super(gemfireProperties);
        }

        @Override
        public void configure(@Nullable String beanName, @NonNull ClientCacheFactoryBean bean) {
            this.configureGemFireProperties(bean);
        }
    }

    protected static class AbstractGemFirePropertiesConfigurer {
        private final Properties gemfireProperties;

        protected AbstractGemFirePropertiesConfigurer(@NonNull Properties gemfireProperties) {
            Assert.notEmpty((Map)gemfireProperties, (String)"GemFire Properties must not be null");
            this.gemfireProperties = gemfireProperties;
        }

        protected void configureGemFireProperties(@NonNull CacheFactoryBean bean) {
            bean.getProperties().putAll((Map<?, ?>)this.gemfireProperties);
        }
    }
}

