/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractFunctionExecutionBeanDefinitionBuilder {
    protected final FunctionExecutionConfiguration configuration;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    AbstractFunctionExecutionBeanDefinitionBuilder(FunctionExecutionConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"FunctionExecutionConfiguration must not be null");
        this.configuration = configuration;
    }

    BeanDefinition build(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder functionProxyFactoryBeanBuilder = BeanDefinitionBuilder.rootBeanDefinition(this.getFunctionProxyFactoryBeanClass());
        functionProxyFactoryBeanBuilder.addConstructorArgValue(this.configuration.getFunctionExecutionInterface());
        functionProxyFactoryBeanBuilder.addConstructorArgReference(BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)this.buildGemfireFunctionOperations(registry), (BeanDefinitionRegistry)registry));
        return functionProxyFactoryBeanBuilder.getBeanDefinition();
    }

    protected AbstractBeanDefinition buildGemfireFunctionOperations(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder functionTemplateBuilder = this.getGemfireFunctionOperationsBeanDefinitionBuilder(registry);
        functionTemplateBuilder.setLazyInit(true);
        Optional.ofNullable(this.configuration.getAttribute("resultCollector")).map(String::valueOf).filter(StringUtils::hasText).ifPresent(reference -> functionTemplateBuilder.addPropertyReference("resultCollector", reference));
        return functionTemplateBuilder.getBeanDefinition();
    }

    protected abstract Class<?> getFunctionProxyFactoryBeanClass();

    protected abstract BeanDefinitionBuilder getGemfireFunctionOperationsBeanDefinitionBuilder(BeanDefinitionRegistry var1);
}

