/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.QueryService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.data.gemfire.GemfireIndexException;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.config.annotation.IndexConfigurer;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class IndexFactoryBean
extends AbstractFactoryBeanSupport<Index>
implements InitializingBean {
    public static final String BASIC_INDEX_DEFINITION = "{ expression = '%1$s', from = '%2$s', type = %3$s }";
    public static final String DETAILED_INDEX_DEFINITION = "{ name = '%1$s', expression = '%2$s', from = '%3$s', imports = '%4$s', type = %5$s }";
    private boolean define = false;
    private boolean ignoreIfExists = false;
    private boolean override = false;
    private Index index;
    private IndexType indexType;
    private List<IndexConfigurer> indexConfigurers = Collections.emptyList();
    private final IndexConfigurer compositeIndexConfigurer = new IndexConfigurer(){

        @Override
        public void configure(String beanName, IndexFactoryBean bean) {
            CollectionUtils.nullSafeCollection(IndexFactoryBean.this.indexConfigurers).forEach(indexConfigurer -> indexConfigurer.configure(beanName, bean));
        }
    };
    private QueryService queryService;
    private RegionService cache;
    private String expression;
    private String from;
    private String imports;
    private String indexName;
    private String name;

    public void afterPropertiesSet() throws Exception {
        this.indexName = this.resolveIndexName();
        this.applyIndexConfigurers(this.indexName);
        this.cache = this.resolveCache();
        this.queryService = this.resolveQueryService();
        this.assertIndexDefinitionConfiguration();
        this.index = this.createIndex(this.queryService, this.indexName);
        this.registerAlias(this.getBeanName(), this.indexName);
    }

    private void applyIndexConfigurers(String indexName) {
        this.applyIndexConfigurers(indexName, this.getCompositeIndexConfigurer());
    }

    protected void applyIndexConfigurers(String indexName, IndexConfigurer ... indexConfigurers) {
        this.applyIndexConfigurers(indexName, Arrays.asList(ArrayUtils.nullSafeArray(indexConfigurers, IndexConfigurer.class)));
    }

    protected void applyIndexConfigurers(String indexName, Iterable<IndexConfigurer> indexConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(indexConfigurers).spliterator(), false).forEach(indexConfigurer -> indexConfigurer.configure(indexName, this));
    }

    private void assertIndexDefinitionConfiguration() {
        Assert.hasText((String)this.expression, (String)"Index expression is required");
        Assert.hasText((String)this.from, (String)"Index from clause is required");
        if (IndexType.isKey(this.indexType)) {
            Assert.isTrue((boolean)StringUtils.isEmpty((Object)this.imports), (String)"Imports are not supported with a KEY Index");
        }
    }

    RegionService resolveCache() {
        GemFireCache resolvedCache = this.cache != null ? this.cache : GemfireUtils.resolveGemFireCache();
        return (RegionService)Optional.ofNullable(resolvedCache).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Cache is required", new Object[0]));
    }

    String resolveIndexName() {
        String resolvedIndexName = StringUtils.hasText((String)this.name) ? this.name : this.getBeanName();
        return Optional.ofNullable(resolvedIndexName).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Index name is required", new Object[0]));
    }

    QueryService resolveQueryService() {
        QueryService resolvedQueryService = this.queryService != null ? this.queryService : this.lookupQueryService();
        return Optional.ofNullable(resolvedQueryService).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("QueryService is required to create an Index", new Object[0]));
    }

    QueryService lookupQueryService() {
        String queryServiceBeanName = "gemfireIndexDefinitionQueryService";
        return Optional.ofNullable(this.getBeanFactory()).filter(beanFactory -> beanFactory.containsBean(queryServiceBeanName)).map(beanFactory -> (QueryService)beanFactory.getBean(queryServiceBeanName, QueryService.class)).orElseGet(() -> this.registerQueryServiceBean(queryServiceBeanName, this.doLookupQueryService()));
    }

    QueryService doLookupQueryService() {
        Supplier<QueryService> queryServiceSupplier = () -> this.cache instanceof ClientCache ? ((ClientCache)this.cache).getLocalQueryService() : this.cache.getQueryService();
        return Optional.ofNullable(this.queryService).orElseGet(queryServiceSupplier);
    }

    QueryService registerQueryServiceBean(String beanName, QueryService queryService) {
        if (this.isDefine()) {
            ((ConfigurableBeanFactory)this.getBeanFactory()).registerSingleton(beanName, (Object)queryService);
        }
        return queryService;
    }

    void registerAlias(String beanName, String indexName) {
        Optional.ofNullable(this.getBeanFactory()).filter(ConfigurableBeanFactory.class::isInstance).filter(it -> beanName != null && !beanName.equals(indexName)).map(ConfigurableBeanFactory.class::cast).ifPresent(it -> it.registerAlias(beanName, indexName));
    }

    Index createIndex(QueryService queryService, String indexName) {
        return this.createIndex(queryService, indexName, false);
    }

    private Index createIndex(QueryService queryService, String indexName, boolean retryAttempted) {
        IndexType indexType = this.indexType;
        String expression = this.expression;
        String from = this.from;
        String imports = this.imports;
        try {
            if (IndexType.isKey(indexType)) {
                return this.createKeyIndex(queryService, indexName, expression, from);
            }
            if (IndexType.isHash(indexType)) {
                return this.createHashIndex(queryService, indexName, expression, from, imports);
            }
            return this.createFunctionalIndex(queryService, indexName, expression, from, imports);
        }
        catch (IndexExistsException cause) {
            Optional<Index> existingIndexByDefinition = this.tryToFindExistingIndexByDefinition(queryService, expression, from, indexType);
            return existingIndexByDefinition.filter(existingIndex -> this.isIgnoreIfExists()).map(existingIndex -> {
                this.logWarning("WARNING! You are choosing to ignore this Index [%1$s] and return the existing Index having the same basic definition [%2$s] but with a different name [%3$s]; Make sure no OQL Query Hints refer to this Index by name [%1$s]", indexName, this.toBasicIndexDefinition(), existingIndex.getName());
                return this.handleIgnore((Index)existingIndex);
            }).orElseGet(() -> existingIndexByDefinition.filter(it -> !retryAttempted && this.isOverride()).map(existingIndex -> {
                this.logWarning("WARNING! You are attempting to 'override' an existing Index [%1$s] having the same basic definition [%2$s] as the Index that will be created by this IndexFactoryBean [%3$s]; 'Override' effectively 'renames' the existing Index [%1$s] by removing it then recreating it under the new name [%3$s] with the same definition; You should be careful to update any existing OQL Query Hints referring to the old Index name [%1$s] to now use the new name [%3$s]", existingIndex.getName(), this.toBasicIndexDefinition(), indexName);
                return this.handleOverride((Index)existingIndex, queryService, indexName);
            }).orElseThrow(() -> {
                String existingIndexName = existingIndexByDefinition.map(Index::getName).orElse("unknown");
                return new GemfireIndexException(String.format("An Index with a different name [%1$s] having the same definition [%2$s] already exists; You may attempt to override the existing Index [%1$s] with the new name [%3$s] by setting the 'override' property to 'true'", existingIndexName, this.toBasicIndexDefinition(), indexName), cause);
            }));
        }
        catch (IndexNameConflictException cause) {
            Optional<Index> existingIndexByName = this.tryToFindExistingIndexByName(queryService, indexName);
            return existingIndexByName.filter(existingIndex -> this.isIgnoreIfExists()).map(existingIndex -> this.handleIgnore(this.warnOnIndexDefinitionMismatch((Index)existingIndex, indexName, "Returning"))).orElseGet(() -> existingIndexByName.filter(it -> !retryAttempted && this.isOverride()).map(existingIndex -> this.handleSmartOverride(this.warnOnIndexDefinitionMismatch((Index)existingIndex, indexName, "Overriding"), queryService, indexName)).orElseThrow(() -> {
                String existingIndexDefinition = existingIndexByName.map(it -> String.format(DETAILED_INDEX_DEFINITION, it.getName(), it.getIndexedExpression(), it.getFromClause(), "unknown", it.getType())).orElse("unknown");
                return new GemfireIndexException(String.format("An Index with the same name [%1$s] having possibly a different definition already exists; you may choose to ignore this Index definition [%2$s] and use the existing Index definition [%3$s] by setting the 'ignoreIfExists' property to 'true'", indexName, this.toDetailedIndexDefinition(), existingIndexDefinition), cause);
            }));
        }
        catch (Exception cause) {
            String message = String.format("Failed to create Index [%s]", this.toDetailedIndexDefinition());
            throw new GemfireIndexException(message, cause);
        }
    }

    private boolean isIndexDefinitionMatch(Index index) {
        return Optional.ofNullable(index).map(it -> {
            IndexType thisIndexType = Optional.ofNullable(this.indexType).orElse(IndexType.FUNCTIONAL);
            boolean result = ObjectUtils.nullSafeEquals((Object)it.getIndexedExpression(), (Object)this.expression) && ObjectUtils.nullSafeEquals((Object)it.getFromClause(), (Object)this.from) && ObjectUtils.nullSafeEquals((Object)((Object)IndexType.valueOf(it.getType())), (Object)((Object)thisIndexType));
            return result;
        }).orElse(false);
    }

    private boolean isNotIndexDefinitionMatch(Index index) {
        return !this.isIndexDefinitionMatch(index);
    }

    private Index warnOnIndexDefinitionMismatch(Index existingIndex, String indexName, String action) {
        if (this.isNotIndexDefinitionMatch(existingIndex)) {
            String existingIndexDefinition = String.format(BASIC_INDEX_DEFINITION, new Object[]{existingIndex.getIndexedExpression(), existingIndex.getFromClause(), IndexType.valueOf(existingIndex.getType())});
            this.logWarning("WARNING! %1$s existing Index [%2$s] having a definition [%3$s] that does not match the Index defined [%4$s] by this IndexFactoryBean [%5$s]", action, existingIndex.getName(), existingIndexDefinition, this.toBasicIndexDefinition(), indexName);
        }
        return existingIndex;
    }

    private Index handleIgnore(Index existingIndex) {
        this.registerAlias(this.getBeanName(), existingIndex.getName());
        return existingIndex;
    }

    private Index handleOverride(Index existingIndex, QueryService queryService, String indexName) {
        try {
            queryService.removeIndex(existingIndex);
            return this.createIndex(queryService, indexName, true);
        }
        catch (Exception cause) {
            throw new GemfireIndexException(String.format("Attempt to 'override' existing Index [%1$s] with the Index that would be created by this IndexFactoryBean [%2$s] failed; you should verify the state of your system and make sure the previously existing Index [%1$s] still exits", existingIndex.getName(), indexName), cause);
        }
    }

    private Index handleSmartOverride(Index existingIndex, QueryService queryService, String indexName) {
        return Optional.of(existingIndex).filter(it -> it.getName().equalsIgnoreCase(indexName)).filter(it -> this.isIndexDefinitionMatch(existingIndex)).orElseGet(() -> this.handleOverride(existingIndex, queryService, indexName));
    }

    String toBasicIndexDefinition() {
        return String.format(BASIC_INDEX_DEFINITION, new Object[]{this.expression, this.from, this.indexType});
    }

    String toDetailedIndexDefinition() {
        return String.format(DETAILED_INDEX_DEFINITION, new Object[]{this.name, this.expression, this.from, this.imports, this.indexType});
    }

    Index createKeyIndex(QueryService queryService, String indexName, String expression, String from) throws Exception {
        if (this.isDefine()) {
            queryService.defineKeyIndex(indexName, expression, from);
            return new IndexWrapper(queryService, indexName);
        }
        return queryService.createKeyIndex(indexName, expression, from);
    }

    Index createHashIndex(QueryService queryService, String indexName, String expression, String from, String imports) throws Exception {
        boolean hasImports = StringUtils.hasText((String)imports);
        if (this.isDefine()) {
            if (hasImports) {
                queryService.defineHashIndex(indexName, expression, from, imports);
            } else {
                queryService.defineHashIndex(indexName, expression, from);
            }
            return new IndexWrapper(queryService, indexName);
        }
        if (hasImports) {
            return queryService.createHashIndex(indexName, expression, from, imports);
        }
        return queryService.createHashIndex(indexName, expression, from);
    }

    Index createFunctionalIndex(QueryService queryService, String indexName, String expression, String from, String imports) throws Exception {
        boolean hasImports = StringUtils.hasText((String)imports);
        if (this.isDefine()) {
            if (hasImports) {
                queryService.defineIndex(indexName, expression, from, imports);
            } else {
                queryService.defineIndex(indexName, expression, from);
            }
            return new IndexWrapper(queryService, indexName);
        }
        if (hasImports) {
            return queryService.createIndex(indexName, expression, from, imports);
        }
        return queryService.createIndex(indexName, expression, from);
    }

    Optional<Index> tryToFindExistingIndexByDefinition(QueryService queryService, String expression, String fromClause, IndexType indexType) {
        for (Index index : CollectionUtils.nullSafeCollection(queryService.getIndexes())) {
            if (!index.getIndexedExpression().equalsIgnoreCase(expression) || !index.getFromClause().equalsIgnoreCase(fromClause) || !indexType.equals((Object)IndexType.valueOf(index.getType()))) continue;
            return Optional.of(index);
        }
        return Optional.empty();
    }

    Optional<Index> tryToFindExistingIndexByName(QueryService queryService, String indexName) {
        for (Index index : CollectionUtils.nullSafeCollection(queryService.getIndexes())) {
            if (!index.getName().equalsIgnoreCase(indexName)) continue;
            return Optional.of(index);
        }
        return Optional.empty();
    }

    protected IndexConfigurer getCompositeIndexConfigurer() {
        return this.compositeIndexConfigurer;
    }

    public Index getIndex() {
        return this.index;
    }

    public Index getObject() {
        return Optional.ofNullable(this.getIndex()).orElseGet(() -> {
            this.index = this.tryToFindExistingIndexByName(this.resolveQueryService(), this.resolveIndexName()).orElse(null);
            return this.index;
        });
    }

    public Class<?> getObjectType() {
        Index index = this.getIndex();
        return index != null ? index.getClass() : Index.class;
    }

    public void setCache(RegionService cache) {
        this.cache = cache;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQueryService(QueryService service) {
        this.queryService = service;
    }

    public void setDefine(boolean define) {
        this.define = define;
    }

    protected boolean isDefine() {
        return this.define;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setImports(String imports) {
        this.imports = imports;
    }

    public void setIgnoreIfExists(boolean ignore) {
        this.ignoreIfExists = ignore;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public void setIndexConfigurers(IndexConfigurer ... indexConfigurers) {
        this.setIndexConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(indexConfigurers, IndexConfigurer.class)));
    }

    public void setIndexConfigurers(List<IndexConfigurer> indexConfigurers) {
        this.indexConfigurers = Optional.ofNullable(indexConfigurers).orElseGet(Collections::emptyList);
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setType(String type) {
        this.setType(IndexType.valueOfIgnoreCase(type));
    }

    public void setType(IndexType type) {
        this.indexType = type;
    }

    protected static final class IndexWrapper
    implements Index {
        private Index index;
        private final QueryService queryService;
        private final String indexName;

        protected IndexWrapper(QueryService queryService, String indexName) {
            Assert.notNull((Object)queryService, (String)"QueryService is required");
            Assert.hasText((String)indexName, (String)"Name of Index is required");
            this.queryService = queryService;
            this.indexName = indexName;
        }

        protected synchronized Index resolveIndex() {
            String indexName = this.getIndexName();
            return Optional.ofNullable(this.index).orElseGet(() -> {
                AtomicReference searchResult = new AtomicReference();
                CollectionUtils.nullSafeCollection(this.getQueryService().getIndexes()).forEach(index -> {
                    if (index.getName().equalsIgnoreCase(indexName)) {
                        searchResult.set(index);
                    }
                });
                return Optional.of(searchResult).map(it -> {
                    this.index = (Index)it.get();
                    return this.index;
                }).orElseThrow(() -> new GemfireIndexException(String.format("Index with name [%s] was not found", indexName), (Exception)null));
            });
        }

        protected Index getIndex() {
            return this.index;
        }

        protected String getIndexName() {
            return Optional.ofNullable(this.indexName).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Index name is required", new Object[0]));
        }

        protected QueryService getQueryService() {
            return this.queryService;
        }

        public String getName() {
            return this.resolveIndex().getName();
        }

        public String getCanonicalizedFromClause() {
            return this.resolveIndex().getCanonicalizedFromClause();
        }

        public String getCanonicalizedIndexedExpression() {
            return this.resolveIndex().getCanonicalizedIndexedExpression();
        }

        public String getCanonicalizedProjectionAttributes() {
            return this.resolveIndex().getCanonicalizedProjectionAttributes();
        }

        public String getFromClause() {
            return this.resolveIndex().getFromClause();
        }

        public String getIndexedExpression() {
            return this.resolveIndex().getIndexedExpression();
        }

        public String getProjectionAttributes() {
            return this.resolveIndex().getProjectionAttributes();
        }

        public Region<?, ?> getRegion() {
            return this.resolveIndex().getRegion();
        }

        public IndexStatistics getStatistics() {
            return this.resolveIndex().getStatistics();
        }

        public org.apache.geode.cache.query.IndexType getType() {
            return this.resolveIndex().getType();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Index)) {
                return false;
            }
            if (obj instanceof IndexWrapper) {
                return this.getIndexName().equals(((IndexWrapper)obj).getIndexName());
            }
            return this.resolveIndex().equals(obj);
        }

        public int hashCode() {
            int hashValue = 37;
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getIndexName());
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.index);
            return hashValue;
        }

        public String toString() {
            return Optional.ofNullable(this.getIndex()).map(String::valueOf).orElseGet(this::getIndexName);
        }
    }
}

