/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Arrays;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.DiskStoreConfiguration;
import org.springframework.data.gemfire.config.annotation.EnableDiskStores;
import org.springframework.data.gemfire.util.ArrayUtils;

public class DiskStoresConfiguration
extends DiskStoreConfiguration {
    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (importingClassMetadata.hasAnnotation(EnableDiskStores.class.getName())) {
            AnnotationAttributes enableDiskStoresAttributes = this.getAnnotationAttributes(importingClassMetadata, EnableDiskStores.class.getName());
            AnnotationAttributes[] diskStores = enableDiskStoresAttributes.getAnnotationArray("diskStores");
            Arrays.stream(ArrayUtils.nullSafeArray(diskStores, AnnotationAttributes.class)).forEach(diskStoreAttributes -> this.registerDiskStoreBeanDefinition(this.mergeDiskStoreAttributes(enableDiskStoresAttributes, (AnnotationAttributes)diskStoreAttributes), registry));
        }
    }

    protected AnnotationAttributes mergeDiskStoreAttributes(AnnotationAttributes enableDiskStoresAttributes, AnnotationAttributes diskStoreAttributes) {
        this.setAttributeIfNotDefault(diskStoreAttributes, "autoCompact", enableDiskStoresAttributes.getBoolean("autoCompact"), false);
        this.setAttributeIfNotDefault(diskStoreAttributes, "compactionThreshold", enableDiskStoresAttributes.getNumber("compactionThreshold"), 50);
        this.setAttributeIfNotDefault(diskStoreAttributes, "maxOplogSize", enableDiskStoresAttributes.getNumber("maxOplogSize"), 1024);
        return diskStoreAttributes;
    }

    private <T> void setAttributeIfNotDefault(AnnotationAttributes diskStoreAttributes, String attributeName, T newValue, T defaultValue) {
        if (!diskStoreAttributes.containsKey((Object)attributeName) || this.toString(diskStoreAttributes.get((Object)attributeName)).equals(this.toString(defaultValue))) {
            diskStoreAttributes.put((Object)attributeName, newValue);
        }
    }

    private String toString(Object value) {
        return String.valueOf(value);
    }
}

