/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public final class CompositeLifecycle
implements Iterable<Lifecycle>,
SmartLifecycle {
    private final List<Lifecycle> lifecycleComponents = new CopyOnWriteArrayList<Lifecycle>();

    public boolean add(@NonNull Lifecycle lifecycleComponent) {
        return lifecycleComponent != null && this.lifecycleComponents.add(lifecycleComponent);
    }

    public boolean isEmpty() {
        return this.lifecycleComponents.isEmpty();
    }

    @Override
    public Iterator<Lifecycle> iterator() {
        return Collections.unmodifiableList(this.lifecycleComponents).iterator();
    }

    public boolean remove(@Nullable Lifecycle lifecycleComponent) {
        return this.lifecycleComponents.remove(lifecycleComponent);
    }

    public int size() {
        return this.lifecycleComponents.size();
    }

    public boolean isRunning() {
        for (Lifecycle lifecycleComponent : this) {
            if (!lifecycleComponent.isRunning()) continue;
            return true;
        }
        return false;
    }

    public void start() {
        this.lifecycleComponents.forEach(Lifecycle::start);
    }

    public void stop() {
        this.lifecycleComponents.forEach(Lifecycle::stop);
    }
}

