/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableAuth;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class AuthConfiguration
extends EmbeddedServiceConfigurationSupport {
    public static final int DEFAULT_PEER_VERIFY_MEMBER_TIMEOUT = 1000;
    public static final String DEFAULT_SECURITY_LOG_LEVEL = "config";
    protected static final String GEMFIRE_SECURITY_PROPERTY_FILE = "gemfireSecurityPropertyFile";
    protected static final String SECURITY_CLIENT_ACCESSOR = "security-client-accessor";
    protected static final String SECURITY_CLIENT_ACCESSOR_POST_PROCESSOR = "security-client-accessor-pp";
    protected static final String SECURITY_CLIENT_AUTH_INIT = "security-client-auth-init";
    protected static final String SECURITY_CLIENT_AUTHENTICATOR = "security-client-authenticator";
    protected static final String SECURITY_CLIENT_DIFFIE_HELLMAN_ALGORITHM = "security-client-dhalgo";
    protected static final String SECURITY_LOG_FILE = "security-log-file";
    protected static final String SECURITY_LOG_LEVEL = "security-log-level";
    protected static final String SECURITY_PEER_AUTH_INIT = "security-peer-auth-init";
    protected static final String SECURITY_PEER_AUTHENTICATOR = "security-peer-authenticator";
    protected static final String SECURITY_PEER_VERIFY_MEMBER_TIMEOUT = "security-peer-verifymember-timeout";

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableAuth.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        gemfireProperties.setProperty(GEMFIRE_SECURITY_PROPERTY_FILE, this.resolveProperty(this.securityProperty("properties-file"), (String)annotationAttributes.get("securityPropertiesFile")));
        gemfireProperties.setProperty(SECURITY_CLIENT_ACCESSOR, this.resolveProperty(this.securityProperty("client.accessor"), (String)annotationAttributes.get("clientAccessor")));
        gemfireProperties.setProperty(SECURITY_CLIENT_ACCESSOR_POST_PROCESSOR, this.resolveProperty(this.securityProperty("client.accessor-post-processor"), (String)annotationAttributes.get("clientAccessorPostProcessor")));
        gemfireProperties.setProperty(SECURITY_CLIENT_AUTH_INIT, this.resolveProperty(this.securityProperty("client.authentication-initializer"), (String)annotationAttributes.get("clientAuthenticationInitializer")));
        gemfireProperties.setProperty(SECURITY_CLIENT_AUTHENTICATOR, this.resolveProperty(this.securityProperty("client.authenticator"), (String)annotationAttributes.get("clientAuthenticator")));
        gemfireProperties.setProperty(SECURITY_CLIENT_DIFFIE_HELLMAN_ALGORITHM, this.resolveProperty(this.securityProperty("client.diffie-hellman-algorithm"), (String)annotationAttributes.get("clientDiffieHellmanAlgorithm")));
        gemfireProperties.setProperty(SECURITY_PEER_AUTH_INIT, this.resolveProperty(this.securityProperty("peer.authentication-initializer"), (String)annotationAttributes.get("peerAuthenticationInitializer")));
        gemfireProperties.setProperty(SECURITY_PEER_AUTHENTICATOR, this.resolveProperty(this.securityProperty("peer.authenticator"), (String)annotationAttributes.get("peerAuthenticator")));
        gemfireProperties.setPropertyIfNotDefault(SECURITY_PEER_VERIFY_MEMBER_TIMEOUT, this.resolveProperty(this.securityProperty("peer.verify-member-timeout"), (Long)annotationAttributes.get("peerVerifyMemberTimeout")), 1000);
        gemfireProperties.setProperty(SECURITY_LOG_FILE, this.resolveProperty(this.securityProperty("log.file"), (String)annotationAttributes.get("securityLogFile")));
        gemfireProperties.setPropertyIfNotDefault(SECURITY_LOG_LEVEL, this.resolveProperty(this.securityProperty("log.level"), (String)annotationAttributes.get("securityLogLevel")), DEFAULT_SECURITY_LOG_LEVEL);
        return gemfireProperties.build();
    }
}

