/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client.support;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.query.QueryService;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;

public abstract class DefaultableDelegatingPoolAdapter {
    private final Pool delegate;
    private Preference preference = Preference.PREFER_POOL;

    public static DefaultableDelegatingPoolAdapter from(Pool delegate) {
        return new DefaultableDelegatingPoolAdapter(delegate){};
    }

    protected DefaultableDelegatingPoolAdapter(Pool delegate) {
        Assert.notNull((Object)delegate, (String)"Pool delegate must not be null");
        this.delegate = delegate;
    }

    protected Pool getDelegate() {
        return this.delegate;
    }

    protected DefaultableDelegatingPoolAdapter setPreference(Preference preference) {
        this.preference = preference;
        return this;
    }

    protected Preference getPreference() {
        return this.preference;
    }

    protected <T> T defaultIfNull(T defaultValue, Supplier<T> valueProvider) {
        return this.prefersPool() ? SpringUtils.defaultIfNull(valueProvider.get(), defaultValue) : (defaultValue != null ? defaultValue : valueProvider.get());
    }

    protected <E, T extends Collection<E>> T defaultIfEmpty(T defaultValue, Supplier<T> valueProvider) {
        if (this.prefersPool()) {
            Collection value = (Collection)valueProvider.get();
            return (T)(CollectionUtils.isEmpty((Collection)value) ? defaultValue : value);
        }
        return (T)(CollectionUtils.isEmpty(defaultValue) ? (Collection)valueProvider.get() : defaultValue);
    }

    public DefaultableDelegatingPoolAdapter preferDefault() {
        return this.setPreference(Preference.PREFER_DEFAULT);
    }

    protected boolean prefersDefault() {
        return Preference.PREFER_DEFAULT.equals((Object)this.getPreference());
    }

    public DefaultableDelegatingPoolAdapter preferPool() {
        return this.setPreference(Preference.PREFER_POOL);
    }

    protected boolean prefersPool() {
        return Preference.PREFER_POOL.equals((Object)this.getPreference());
    }

    public boolean isDestroyed() {
        return this.getDelegate().isDestroyed();
    }

    public int getFreeConnectionTimeout(Integer defaultFreeConnectionTimeout) {
        return this.defaultIfNull(defaultFreeConnectionTimeout, () -> this.getDelegate().getFreeConnectionTimeout());
    }

    public long getIdleTimeout(Long defaultIdleTimeout) {
        return this.defaultIfNull(defaultIdleTimeout, () -> this.getDelegate().getIdleTimeout());
    }

    public int getLoadConditioningInterval(Integer defaultLoadConditioningInterval) {
        return this.defaultIfNull(defaultLoadConditioningInterval, () -> this.getDelegate().getLoadConditioningInterval());
    }

    public List<InetSocketAddress> getLocators(List<InetSocketAddress> defaultLocators) {
        return this.defaultIfEmpty(defaultLocators, () -> this.getDelegate().getLocators());
    }

    public int getMaxConnections(Integer defaultMaxConnections) {
        return this.defaultIfNull(defaultMaxConnections, () -> this.getDelegate().getMaxConnections());
    }

    public int getMinConnections(Integer defaultMinConnections) {
        return this.defaultIfNull(defaultMinConnections, () -> this.getDelegate().getMinConnections());
    }

    public boolean getMultiuserAuthentication(Boolean defaultMultiUserAuthentication) {
        return this.defaultIfNull(defaultMultiUserAuthentication, () -> this.getDelegate().getMultiuserAuthentication());
    }

    public String getName() {
        return this.getDelegate().getName();
    }

    public int getPendingEventCount() {
        return this.getDelegate().getPendingEventCount();
    }

    public long getPingInterval(Long defaultPingInterval) {
        return this.defaultIfNull(defaultPingInterval, () -> this.getDelegate().getPingInterval());
    }

    public boolean getPRSingleHopEnabled(Boolean defaultPrSingleHopEnabled) {
        return this.defaultIfNull(defaultPrSingleHopEnabled, () -> this.getDelegate().getPRSingleHopEnabled());
    }

    public QueryService getQueryService(QueryService defaultQueryService) {
        return this.defaultIfNull(defaultQueryService, () -> this.getDelegate().getQueryService());
    }

    public int getReadTimeout(Integer defaultReadTimeout) {
        return this.defaultIfNull(defaultReadTimeout, () -> this.getDelegate().getReadTimeout());
    }

    public int getRetryAttempts(Integer defaultRetryAttempts) {
        return this.defaultIfNull(defaultRetryAttempts, () -> this.getDelegate().getRetryAttempts());
    }

    public String getServerGroup(String defaultServerGroup) {
        return this.defaultIfNull(defaultServerGroup, () -> this.getDelegate().getServerGroup());
    }

    public List<InetSocketAddress> getServers(List<InetSocketAddress> defaultServers) {
        return this.defaultIfEmpty(defaultServers, () -> this.getDelegate().getServers());
    }

    public int getSocketBufferSize(Integer defaultSocketBufferSize) {
        return this.defaultIfNull(defaultSocketBufferSize, () -> this.getDelegate().getSocketBufferSize());
    }

    public int getSocketConnectTimeout(Integer defaultSocketConnectTimeout) {
        return this.defaultIfNull(defaultSocketConnectTimeout, () -> this.getDelegate().getSocketConnectTimeout());
    }

    public int getStatisticInterval(Integer defaultStatisticInterval) {
        return this.defaultIfNull(defaultStatisticInterval, () -> this.getDelegate().getStatisticInterval());
    }

    public int getSubscriptionAckInterval(Integer defaultSubscriptionAckInterval) {
        return this.defaultIfNull(defaultSubscriptionAckInterval, () -> this.getDelegate().getSubscriptionAckInterval());
    }

    public boolean getSubscriptionEnabled(Boolean defaultSubscriptionEnabled) {
        return this.defaultIfNull(defaultSubscriptionEnabled, () -> this.getDelegate().getSubscriptionEnabled());
    }

    public int getSubscriptionMessageTrackingTimeout(Integer defaultSubscriptionMessageTrackingTimeout) {
        return this.defaultIfNull(defaultSubscriptionMessageTrackingTimeout, () -> this.getDelegate().getSubscriptionMessageTrackingTimeout());
    }

    public int getSubscriptionRedundancy(Integer defaultSubscriptionRedundancy) {
        return this.defaultIfNull(defaultSubscriptionRedundancy, () -> this.getDelegate().getSubscriptionRedundancy());
    }

    public int getSubscriptionTimeoutMultiplier(Integer defaultSubscriptionTimeoutMultiplier) {
        return this.defaultIfNull(defaultSubscriptionTimeoutMultiplier, () -> this.getDelegate().getSubscriptionTimeoutMultiplier());
    }

    public boolean getThreadLocalConnections(Boolean defaultThreadLocalConnections) {
        return this.defaultIfNull(defaultThreadLocalConnections, () -> this.getDelegate().getThreadLocalConnections());
    }

    public void destroy() {
        this.getDelegate().destroy();
    }

    public void destroy(boolean keepAlive) {
        this.getDelegate().destroy(keepAlive);
    }

    public void releaseThreadLocalConnection() {
        this.getDelegate().releaseThreadLocalConnection();
    }

    static interface ValueProvider<T> {
        public T getValue();
    }

    static enum Preference {
        PREFER_DEFAULT,
        PREFER_POOL;

    }
}

