/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.internal.security.SecurityService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.config.annotation.EnableSecurity;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@Conditional(value={ApacheShiroPresentCondition.class})
public class ApacheShiroSecurityConfiguration
extends AbstractAnnotationConfigSupport {
    protected Class getAnnotationType() {
        return EnableSecurity.class;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(Optional.ofNullable(beanFactory).filter(it -> it instanceof ListableBeanFactory).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("BeanFactory [%s] must be an instance of ListableBeanFactory", ObjectUtils.nullSafeClassName((Object)beanFactory))));
    }

    protected ListableBeanFactory getListableBeanFactory() {
        return (ListableBeanFactory)this.getBeanFactory();
    }

    @Bean
    public BeanPostProcessor shiroLifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public SecurityManager shiroSecurityManager(GemFireCache gemfireCache) {
        SecurityManager shiroSecurityManager = null;
        List<Realm> realms = this.resolveRealms();
        if (!realms.isEmpty()) {
            shiroSecurityManager = this.registerSecurityManager((SecurityManager)new DefaultSecurityManager(realms));
            if (!this.enableApacheGeodeSecurity()) {
                throw RuntimeExceptionFactory.newIllegalStateException("Failed to enable security services in %s", GemfireUtils.apacheGeodeProductName());
            }
        }
        return shiroSecurityManager;
    }

    protected List<Realm> resolveRealms() {
        try {
            Map realmBeans = this.getListableBeanFactory().getBeansOfType(Realm.class, false, true);
            ArrayList<Realm> realms = new ArrayList<Realm>(CollectionUtils.nullSafeMap(realmBeans).values());
            realms.sort((Comparator<Realm>)OrderComparator.INSTANCE);
            return realms;
        }
        catch (Exception ignore) {
            return Collections.emptyList();
        }
    }

    protected SecurityManager registerSecurityManager(SecurityManager securityManager) {
        Assert.notNull((Object)securityManager, (String)"The Apache Shiro SecurityManager to register must not be null");
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        return securityManager;
    }

    protected boolean enableApacheGeodeSecurity() {
        SecurityService securityService = SecurityService.getSecurityService();
        if (securityService != null) {
            String isIntegratedSecurityFieldName = "isIntegratedSecurity";
            Field isIntegratedSecurity = ReflectionUtils.findField(securityService.getClass(), (String)isIntegratedSecurityFieldName, Boolean.class);
            if ((isIntegratedSecurity = Optional.ofNullable(isIntegratedSecurity).orElseGet(() -> ReflectionUtils.findField(securityService.getClass(), (String)isIntegratedSecurityFieldName, Boolean.TYPE))) != null) {
                ReflectionUtils.makeAccessible((Field)isIntegratedSecurity);
                ReflectionUtils.setField((Field)isIntegratedSecurity, (Object)securityService, (Object)Boolean.TRUE);
                return true;
            }
        }
        return false;
    }

    public static class ApacheShiroPresentCondition
    implements Condition {
        protected static final String APACHE_SHIRO_LIFECYCLE_BEAN_POST_PROCESSOR_CLASS_NAME = "org.apache.shiro.spring.LifecycleBeanPostProcessor";

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ClassUtils.isPresent((String)APACHE_SHIRO_LIFECYCLE_BEAN_POST_PROCESSOR_CLASS_NAME, (ClassLoader)context.getClassLoader());
        }
    }
}

