/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.function.annotation.OnMember;
import org.springframework.data.gemfire.function.annotation.OnMembers;
import org.springframework.data.gemfire.function.annotation.OnRegion;
import org.springframework.data.gemfire.function.annotation.OnServer;
import org.springframework.data.gemfire.function.annotation.OnServers;
import org.springframework.data.gemfire.function.config.FunctionExecutionComponentProvider;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfigurationSource;

abstract class AbstractFunctionExecutionConfigurationSource
implements FunctionExecutionConfigurationSource {
    private static Set<Class<? extends Annotation>> functionExecutionAnnotationTypes;
    protected Log logger = LogFactory.getLog(this.getClass());

    AbstractFunctionExecutionConfigurationSource() {
    }

    static Set<Class<? extends Annotation>> getFunctionExecutionAnnotationTypes() {
        return functionExecutionAnnotationTypes;
    }

    static Set<String> getFunctionExecutionAnnotationTypeNames() {
        HashSet<String> functionExecutionTypeNames = new HashSet<String>(AbstractFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypes().size());
        for (Class<? extends Annotation> annotationType : AbstractFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypes()) {
            functionExecutionTypeNames.add(annotationType.getName());
        }
        return functionExecutionTypeNames;
    }

    public Collection<ScannedGenericBeanDefinition> getCandidates(ResourceLoader loader) {
        FunctionExecutionComponentProvider scanner = new FunctionExecutionComponentProvider(this.getIncludeFilters(), AbstractFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypes());
        scanner.setResourceLoader(loader);
        for (TypeFilter filter : this.getExcludeFilters()) {
            scanner.addExcludeFilter(filter);
        }
        HashSet<ScannedGenericBeanDefinition> result = new HashSet<ScannedGenericBeanDefinition>();
        for (String basePackage : this.getBasePackages()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("scanning package " + basePackage));
            }
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition beanDefinition : candidateComponents) {
                result.add((ScannedGenericBeanDefinition)beanDefinition);
            }
        }
        return result;
    }

    static {
        HashSet<Class<OnMembers>> annotationTypes = new HashSet<Class<OnMembers>>(5);
        annotationTypes.add(OnRegion.class);
        annotationTypes.add(OnServer.class);
        annotationTypes.add(OnServers.class);
        annotationTypes.add(OnMember.class);
        annotationTypes.add(OnMembers.class);
        functionExecutionAnnotationTypes = Collections.unmodifiableSet(annotationTypes);
    }
}

