/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.apache.geode.cache.Region;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryPostProcessor;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class GemfireRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Iterable<Region<?, ?>> regions;
    private MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext;

    public GemfireRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.regions = Collections.unmodifiableSet(applicationContext.getBeansOfType(Region.class).entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet()));
    }

    protected Optional<ApplicationContext> getApplicationContext() {
        return Optional.ofNullable(this.applicationContext);
    }

    @Autowired(required=false)
    public void setGemfireMappingContext(MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext) {
        this.setMappingContext(mappingContext);
        this.mappingContext = mappingContext;
    }

    protected MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> getGemfireMappingContext() {
        return this.mappingContext;
    }

    private MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> resolveGemfireMappingContext() {
        MappingContext<GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext = this.getGemfireMappingContext();
        Assert.state((mappingContext != null ? 1 : 0) != 0, (String)"GemfireMappingContext must not be null");
        return mappingContext;
    }

    protected Iterable<Region<?, ?>> getRegions() {
        return this.regions;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        GemfireRepositoryFactory repositoryFactory = new GemfireRepositoryFactory(this.getRegions(), this.getGemfireMappingContext());
        this.getApplicationContext().map(applicationContext -> new QueryPostProcessorRegistrationOnQueryCreationListener((ApplicationContext)applicationContext)).ifPresent(arg_0 -> ((GemfireRepositoryFactory)repositoryFactory).addQueryCreationListener(arg_0));
        return repositoryFactory;
    }

    public void afterPropertiesSet() {
        this.resolveGemfireMappingContext();
        super.afterPropertiesSet();
    }

    static class QueryPostProcessorMetadata {
        private static final Map<QueryPostProcessorKey, QueryPostProcessorMetadata> cache = new WeakHashMap<QueryPostProcessorKey, QueryPostProcessorMetadata>();
        private final Class<?> declaredRepositoryType;
        private final QueryPostProcessor<?, ?> queryPostProcessor;

        static QueryPostProcessorMetadata from(@org.springframework.lang.NonNull QueryPostProcessor<?, ?> queryPostProcessor) {
            return cache.computeIfAbsent(QueryPostProcessorKey.of(queryPostProcessor), key -> new QueryPostProcessorMetadata(key.getQueryPostProcessor()));
        }

        QueryPostProcessorMetadata(@org.springframework.lang.NonNull QueryPostProcessor<?, ?> queryPostProcessor) {
            Assert.notNull(queryPostProcessor, (String)"QueryPostProcessor must not be null");
            this.queryPostProcessor = queryPostProcessor;
            List typeArguments = ClassTypeInformation.from(queryPostProcessor.getClass()).getRequiredSuperTypeInformation(QueryPostProcessor.class).getTypeArguments();
            this.declaredRepositoryType = Optional.of(typeArguments).filter(list -> !list.isEmpty()).map(list -> (TypeInformation)list.get(0)).map(typeInfo -> typeInfo.getType()).orElse(Repository.class);
        }

        @org.springframework.lang.NonNull
        Class<?> getDeclaredRepositoryType() {
            return this.declaredRepositoryType;
        }

        @org.springframework.lang.NonNull
        QueryPostProcessor<?, String> getQueryPostProcessor() {
            return this.queryPostProcessor;
        }

        boolean isMatch(Class<?> repositoryInterface) {
            return repositoryInterface != null && (this.getDeclaredRepositoryType().isAssignableFrom(repositoryInterface) || repositoryInterface.isAnnotationPresent(RepositoryDefinition.class));
        }

        GemfireRepositoryQuery register(GemfireRepositoryQuery repositoryQuery) {
            repositoryQuery.register(this.getQueryPostProcessor());
            return repositoryQuery;
        }

        private static class QueryPostProcessorKey {
            @NonNull
            QueryPostProcessor<?, ?> queryPostProcessor;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof QueryPostProcessorKey)) {
                    return false;
                }
                QueryPostProcessorKey other = (QueryPostProcessorKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                QueryPostProcessor<?, ?> this$queryPostProcessor = this.getQueryPostProcessor();
                QueryPostProcessor<?, ?> other$queryPostProcessor = other.getQueryPostProcessor();
                return !(this$queryPostProcessor == null ? other$queryPostProcessor != null : !this$queryPostProcessor.equals(other$queryPostProcessor));
            }

            protected boolean canEqual(Object other) {
                return other instanceof QueryPostProcessorKey;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                QueryPostProcessor<?, ?> $queryPostProcessor = this.getQueryPostProcessor();
                result = result * 59 + ($queryPostProcessor == null ? 43 : $queryPostProcessor.hashCode());
                return result;
            }

            private QueryPostProcessorKey(@NonNull QueryPostProcessor<?, ?> queryPostProcessor) {
                if (queryPostProcessor == null) {
                    throw new NullPointerException("queryPostProcessor");
                }
                this.queryPostProcessor = queryPostProcessor;
            }

            public static QueryPostProcessorKey of(@NonNull QueryPostProcessor<?, ?> queryPostProcessor) {
                return new QueryPostProcessorKey(queryPostProcessor);
            }

            @NonNull
            public QueryPostProcessor<?, ?> getQueryPostProcessor() {
                return this.queryPostProcessor;
            }
        }
    }

    protected class QueryPostProcessorRegistrationOnQueryCreationListener
    implements QueryCreationListener<GemfireRepositoryQuery> {
        private Iterable<QueryPostProcessorMetadata> queryPostProcessorsMetadata;

        public QueryPostProcessorRegistrationOnQueryCreationListener(ApplicationContext applicationContext) {
            Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
            ArrayList queryPostProcessors = new ArrayList(applicationContext.getBeansOfType(QueryPostProcessor.class).values());
            queryPostProcessors.sort(OrderComparator.INSTANCE);
            this.queryPostProcessorsMetadata = queryPostProcessors.stream().map(QueryPostProcessorMetadata::from).collect(Collectors.toList());
        }

        protected Iterable<QueryPostProcessorMetadata> getQueryPostProcessorsMetadata() {
            return this.queryPostProcessorsMetadata;
        }

        public void onCreation(GemfireRepositoryQuery repositoryQuery) {
            Class repositoryInterface = GemfireRepositoryFactoryBean.this.getRepositoryInformation().getRepositoryInterface();
            StreamSupport.stream(this.getQueryPostProcessorsMetadata().spliterator(), false).filter(queryPostProcessorMetadata -> queryPostProcessorMetadata.isMatch(repositoryInterface)).forEach(queryPostProcessorMetadata -> queryPostProcessorMetadata.register(repositoryQuery));
        }
    }
}

