/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableStatistics;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class StatisticsConfiguration
extends EmbeddedServiceConfigurationSupport {
    public static final boolean DEFAULT_ENABLE_TIME_STATISTICS = false;
    public static final int DEFAULT_ARCHIVE_DISK_SPACE_LIMIT = 0;
    public static final int DEFAULT_ARCHIVE_FILE_SIZE_LIMIT = 0;
    public static final int DEFAULT_STATISTIC_SAMPLE_RATE = 1000;

    protected Class getAnnotationType() {
        return EnableStatistics.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = new PropertiesBuilder();
        gemfireProperties.setProperty("statistic-sampling-enabled", this.resolveProperty(this.statsProperty("sampling-enabled"), true));
        gemfireProperties.setPropertyIfNotDefault("archive-disk-space-limit", this.resolveProperty(this.statsProperty("archive-disk-space-limit"), (Integer)annotationAttributes.get("archiveDiskSpaceLimit")), 0);
        gemfireProperties.setProperty("statistic-archive-file", this.resolveProperty(this.statsProperty("archive-file"), (String)annotationAttributes.get("archiveFile")));
        gemfireProperties.setPropertyIfNotDefault("archive-file-size-limit", this.resolveProperty(this.statsProperty("archive-file-size-limit"), (Integer)annotationAttributes.get("archiveFileSizeLimit")), 0);
        gemfireProperties.setProperty("enable-time-statistics", this.resolveProperty(this.statsProperty("enable-time-statistics"), Boolean.TRUE.equals(annotationAttributes.get("enableTimeStatistics"))));
        gemfireProperties.setPropertyIfNotDefault("statistic-sample-rate", this.resolveProperty(this.statsProperty("sample-rate"), (Long)annotationAttributes.get("sampleRate")), 1000);
        return gemfireProperties.build();
    }
}

