/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.GemFireException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.internal.cache.LocalRegion;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.gemfire.GemfireAccessor;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireCallback;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GemfireTemplate
extends GemfireAccessor
implements GemfireOperations {
    private boolean exposeNativeRegion = false;
    private Region<?, ?> regionProxy;

    public GemfireTemplate() {
    }

    public <K, V> GemfireTemplate(Region<K, V> region) {
        this.setRegion(region);
        this.afterPropertiesSet();
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.regionProxy = this.createRegionProxy(this.getRegion());
    }

    public void setExposeNativeRegion(boolean exposeNativeRegion) {
        this.exposeNativeRegion = exposeNativeRegion;
    }

    public boolean isExposeNativeRegion() {
        return this.exposeNativeRegion;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getRegion().containsKey(key);
    }

    @Override
    public boolean containsKeyOnServer(Object key) {
        return this.getRegion().containsKeyOnServer(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getRegion().containsValue(value);
    }

    @Override
    public boolean containsValueForKey(Object key) {
        return this.getRegion().containsValueForKey(key);
    }

    @Override
    public <K, V> void create(K key, V value) {
        try {
            this.getRegion().create(key, value);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V get(K key) {
        try {
            return (V)this.getRegion().get(key);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> Map<K, V> getAll(Collection<?> keys) {
        try {
            return this.getRegion().getAll(keys);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V put(K key, V value) {
        try {
            return (V)this.getRegion().put(key, value);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> void putAll(Map<? extends K, ? extends V> map) {
        try {
            this.getRegion().putAll(map);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V putIfAbsent(K key, V value) {
        try {
            return (V)this.getRegion().putIfAbsent(key, value);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V remove(K key) {
        try {
            return (V)this.getRegion().remove(key);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V replace(K key, V value) {
        try {
            return (V)this.getRegion().replace(key, value);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> boolean replace(K key, V oldValue, V newValue) {
        try {
            return this.getRegion().replace(key, oldValue, newValue);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <E> SelectResults<E> query(String query) {
        try {
            return this.getRegion().query(query);
        }
        catch (IndexInvalidException e) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)e));
        }
        catch (QueryInvalidException e) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)e));
        }
        catch (GemFireCheckedException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (RuntimeException ex) {
            if (GemfireCacheUtils.isCqInvalidException(ex)) {
                throw GemfireCacheUtils.convertCqInvalidException(ex);
            }
            throw ex;
        }
    }

    @Override
    public <E> SelectResults<E> find(String queryString, Object ... params) throws InvalidDataAccessApiUsageException {
        try {
            QueryService queryService = this.resolveQueryService(this.getRegion());
            Query query = queryService.newQuery(queryString);
            Object result = query.execute(params);
            if (result instanceof SelectResults) {
                return (SelectResults)result;
            }
            throw new InvalidDataAccessApiUsageException(String.format("The result from executing query [%1$s] was not an instance of SelectResults [%2$s]", queryString, result));
        }
        catch (IndexInvalidException | QueryInvalidException e) {
            throw this.convertGemFireQueryException((RuntimeException)e);
        }
        catch (GemFireCheckedException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (RuntimeException e) {
            if (GemfireCacheUtils.isCqInvalidException(e)) {
                throw GemfireCacheUtils.convertCqInvalidException(e);
            }
            throw e;
        }
    }

    @Override
    public <T> T findUnique(String queryString, Object ... params) throws InvalidDataAccessApiUsageException {
        try {
            QueryService queryService = this.resolveQueryService(this.getRegion());
            Query query = queryService.newQuery(queryString);
            Object result = query.execute(params);
            if (result instanceof SelectResults) {
                SelectResults selectResults = (SelectResults)result;
                List results = selectResults.asList();
                if (results.size() == 1) {
                    result = results.get(0);
                } else {
                    throw new InvalidDataAccessApiUsageException(String.format("The result returned from query [%1$s]) was not unique [%2$s]", queryString, result));
                }
            }
            return (T)result;
        }
        catch (IndexInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (QueryInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (GemFireCheckedException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (RuntimeException ex) {
            if (GemfireCacheUtils.isCqInvalidException(ex)) {
                throw GemfireCacheUtils.convertCqInvalidException(ex);
            }
            throw ex;
        }
    }

    protected QueryService resolveQueryService(Region<?, ?> region) {
        return region.getRegionService() instanceof ClientCache ? this.resolveClientQueryService(region) : this.queryServiceFrom(region);
    }

    QueryService resolveClientQueryService(Region<?, ?> region) {
        ClientCache clientCache = (ClientCache)region.getRegionService();
        return this.requiresLocalQueryService(region) ? clientCache.getLocalQueryService() : (this.requiresPooledQueryService(region) ? clientCache.getQueryService(this.poolNameFrom(region)) : this.queryServiceFrom(region));
    }

    boolean requiresLocalQueryService(Region<?, ?> region) {
        return Scope.LOCAL.equals(region.getAttributes().getScope()) && this.isLocalWithNoServerProxy(region);
    }

    boolean isLocalWithNoServerProxy(Region<?, ?> region) {
        return region instanceof LocalRegion && !((LocalRegion)region).hasServerProxy();
    }

    boolean requiresPooledQueryService(Region<?, ?> region) {
        return StringUtils.hasText((String)this.poolNameFrom(region));
    }

    QueryService queryServiceFrom(Region<?, ?> region) {
        return region.getRegionService().getQueryService();
    }

    String poolNameFrom(Region<?, ?> region) {
        return region.getAttributes().getPoolName();
    }

    @Override
    public <T> T execute(GemfireCallback<T> action) throws DataAccessException {
        return this.execute(action, this.isExposeNativeRegion());
    }

    @Override
    public <T> T execute(GemfireCallback<T> action, boolean exposeNativeRegion) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        try {
            Object regionArgument = exposeNativeRegion ? this.getRegion() : this.regionProxy;
            return action.doInGemfire((Region<?, ?>)regionArgument);
        }
        catch (IndexInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (QueryInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (GemFireCheckedException ex) {
            throw this.convertGemFireAccessException(ex);
        }
        catch (GemFireException ex) {
            throw this.convertGemFireAccessException(ex);
        }
        catch (RuntimeException ex) {
            if (GemfireCacheUtils.isCqInvalidException(ex)) {
                throw GemfireCacheUtils.convertCqInvalidException(ex);
            }
            throw ex;
        }
    }

    protected <K, V> Region<K, V> createRegionProxy(Region<K, V> region) {
        Class<?> regionType = region.getClass();
        return (Region)Proxy.newProxyInstance(regionType.getClassLoader(), ClassUtils.getAllInterfacesForClass(regionType, (ClassLoader)this.getClass().getClassLoader()), (InvocationHandler)new RegionCloseSuppressingInvocationHandler(region));
    }

    private static class RegionCloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Region<?, ?> target;

        public RegionCloseSuppressingInvocationHandler(Region<?, ?> target) {
            Assert.notNull(target, (String)"The Region to target must not be null.");
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

