/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.snapshot.filter;

import com.gemstone.gemfire.cache.snapshot.SnapshotFilter;
import java.util.Map;

public class ComposableSnapshotFilter<K, V>
implements SnapshotFilter<K, V> {
    private final Operator operator;
    private final SnapshotFilter<K, V> leftOperand;
    private final SnapshotFilter<K, V> rightOperand;

    private ComposableSnapshotFilter(SnapshotFilter<K, V> leftOperand, Operator operator, SnapshotFilter<K, V> rightOperand) {
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    static <K, V> SnapshotFilter<K, V>[] nullSafeArray(SnapshotFilter<K, V> ... array) {
        return array != null ? array : new SnapshotFilter[]{};
    }

    protected static <K, V> SnapshotFilter<K, V> compose(Operator operator, SnapshotFilter<K, V> ... snapshotFilters) {
        ComposableSnapshotFilter<K, V> composedSnapshotFilter = null;
        for (ComposableSnapshotFilter<K, V> composableSnapshotFilter : ComposableSnapshotFilter.nullSafeArray(snapshotFilters)) {
            composedSnapshotFilter = composedSnapshotFilter == null ? composableSnapshotFilter : new ComposableSnapshotFilter<K, V>(composableSnapshotFilter, operator, composedSnapshotFilter);
        }
        return composedSnapshotFilter;
    }

    public static <K, V> SnapshotFilter<K, V> and(SnapshotFilter<K, V> ... snapshotFilters) {
        return ComposableSnapshotFilter.compose(Operator.AND, snapshotFilters);
    }

    public static <K, V> SnapshotFilter<K, V> or(SnapshotFilter<K, V> ... snapshotFilters) {
        return ComposableSnapshotFilter.compose(Operator.OR, snapshotFilters);
    }

    public boolean accept(Map.Entry<K, V> entry) {
        return this.operator.operate(this.leftOperand.accept(entry), this.rightOperand.accept(entry));
    }

    protected static enum Operator {
        AND,
        OR;


        public boolean isAnd() {
            return this == AND;
        }

        public boolean isOr() {
            return this == OR;
        }

        public boolean operate(boolean leftOperand, boolean rightOperand) {
            return this.isAnd() ? leftOperand && rightOperand : leftOperand || rightOperand;
        }
    }
}

