/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.context.annotation.Import;
import org.springframework.data.gemfire.config.annotation.SslConfiguration;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@Import(value={SslConfiguration.class})
public @interface EnableSsl {
    public String ciphers() default "any";

    public Component[] components() default {Component.CLUSTER};

    public String keystore() default "";

    public String keystorePassword() default "";

    public String keystoreType() default "";

    public String protocols() default "any";

    public boolean requireAuthentication() default true;

    public String truststore() default "";

    public String truststorePassword() default "";

    public static enum Component {
        CLUSTER("cluster"),
        GATEWAY("gateway"),
        HTTP("http-service"),
        JMX("jmx-manager"),
        LOCATOR("locator"),
        SERVER("server");

        private final String prefix;

        private Component(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

