/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.client.support.DefaultableDelegatingPoolAdapter;
import org.springframework.data.gemfire.client.support.DelegatingPoolAdapter;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ClientCacheFactoryBean
extends CacheFactoryBean
implements ApplicationListener<ContextRefreshedEvent> {
    private Boolean keepAlive = false;
    private Boolean multiUserAuthentication;
    private Boolean prSingleHopEnabled;
    private Boolean readyForEvents;
    private Boolean subscriptionEnabled;
    private Boolean threadLocalConnections;
    private ConnectionEndpointList locators = new ConnectionEndpointList();
    private ConnectionEndpointList servers = new ConnectionEndpointList();
    private Integer durableClientTimeout;
    private Integer freeConnectionTimeout;
    private Integer loadConditioningInterval;
    private Integer maxConnections;
    private Integer minConnections;
    private Integer readTimeout;
    private Integer retryAttempts;
    private Integer socketBufferSize;
    private Integer statisticsInterval;
    private Integer subscriptionAckInterval;
    private Integer subscriptionMessageTrackingTimeout;
    private Integer subscriptionRedundancy;
    private Long idleTimeout;
    private Long pingInterval;
    private Pool pool;
    private String durableClientId;
    private String poolName;
    private String serverGroup;

    @Override
    protected void postProcessBeforeCacheInitialization(Properties gemfireProperties) {
    }

    @Override
    protected <T extends GemFireCache> T fetchCache() {
        ClientCache cache = (ClientCache)this.getCache();
        return (T)(cache != null ? cache : ClientCacheFactory.getAnyInstance());
    }

    @Override
    protected Properties resolveProperties() {
        Properties gemfireProperties = super.resolveProperties();
        Object distributedSystem = this.getDistributedSystem();
        if (GemfireUtils.isConnected(distributedSystem)) {
            Properties distributedSystemProperties = (Properties)distributedSystem.getProperties().clone();
            distributedSystemProperties.putAll((Map<?, ?>)gemfireProperties);
            gemfireProperties = distributedSystemProperties;
        }
        GemfireUtils.configureDurableClient(gemfireProperties, this.durableClientId, this.durableClientTimeout);
        return gemfireProperties;
    }

    <T extends DistributedSystem> T getDistributedSystem() {
        return GemfireUtils.getDistributedSystem();
    }

    @Override
    protected Object createFactory(Properties gemfireProperties) {
        return new ClientCacheFactory(gemfireProperties);
    }

    @Override
    protected Object prepareFactory(Object factory) {
        return this.initializePool(this.initializePdx((ClientCacheFactory)factory));
    }

    ClientCacheFactory initializePdx(ClientCacheFactory clientCacheFactory) {
        if (this.isPdxOptionsSpecified()) {
            if (this.getPdxSerializer() != null) {
                Assert.isInstanceOf(PdxSerializer.class, (Object)this.getPdxSerializer(), (String)String.format("[%1$s] of type [%2$s] is not a PdxSerializer;", this.getPdxSerializer(), ObjectUtils.nullSafeClassName((Object)this.getPdxSerializer())));
                clientCacheFactory.setPdxSerializer((PdxSerializer)this.getPdxSerializer());
            }
            if (this.getPdxDiskStoreName() != null) {
                clientCacheFactory.setPdxDiskStore(this.getPdxDiskStoreName());
            }
            if (this.getPdxIgnoreUnreadFields() != null) {
                clientCacheFactory.setPdxIgnoreUnreadFields(this.getPdxIgnoreUnreadFields().booleanValue());
            }
            if (this.getPdxPersistent() != null) {
                clientCacheFactory.setPdxPersistent(this.getPdxPersistent().booleanValue());
            }
            if (this.getPdxReadSerialized() != null) {
                clientCacheFactory.setPdxReadSerialized(this.getPdxReadSerialized().booleanValue());
            }
        }
        return clientCacheFactory;
    }

    ClientCacheFactory initializePool(ClientCacheFactory clientCacheFactory) {
        boolean hasLocators;
        DefaultableDelegatingPoolAdapter pool = DefaultableDelegatingPoolAdapter.from(DelegatingPoolAdapter.from(this.resolvePool())).preferDefault();
        clientCacheFactory.setPoolFreeConnectionTimeout(pool.getFreeConnectionTimeout(this.getFreeConnectionTimeout()));
        clientCacheFactory.setPoolIdleTimeout(pool.getIdleTimeout(this.getIdleTimeout()));
        clientCacheFactory.setPoolLoadConditioningInterval(pool.getLoadConditioningInterval(this.getLoadConditioningInterval()));
        clientCacheFactory.setPoolMaxConnections(pool.getMaxConnections(this.getMaxConnections()));
        clientCacheFactory.setPoolMinConnections(pool.getMinConnections(this.getMinConnections()));
        clientCacheFactory.setPoolMultiuserAuthentication(pool.getMultiuserAuthentication(this.getMultiUserAuthentication()));
        clientCacheFactory.setPoolPRSingleHopEnabled(pool.getPRSingleHopEnabled(this.getPrSingleHopEnabled()));
        clientCacheFactory.setPoolPingInterval(pool.getPingInterval(this.getPingInterval()));
        clientCacheFactory.setPoolReadTimeout(pool.getReadTimeout(this.getReadTimeout()));
        clientCacheFactory.setPoolRetryAttempts(pool.getRetryAttempts(this.getRetryAttempts()));
        clientCacheFactory.setPoolServerGroup(pool.getServerGroup(this.getServerGroup()));
        clientCacheFactory.setPoolSocketBufferSize(pool.getSocketBufferSize(this.getSocketBufferSize()));
        clientCacheFactory.setPoolStatisticInterval(pool.getStatisticInterval(this.getStatisticsInterval()));
        clientCacheFactory.setPoolSubscriptionAckInterval(pool.getSubscriptionAckInterval(this.getSubscriptionAckInterval()));
        clientCacheFactory.setPoolSubscriptionEnabled(pool.getSubscriptionEnabled(this.getSubscriptionEnabled()));
        clientCacheFactory.setPoolSubscriptionMessageTrackingTimeout(pool.getSubscriptionMessageTrackingTimeout(this.getSubscriptionMessageTrackingTimeout()));
        clientCacheFactory.setPoolSubscriptionRedundancy(pool.getSubscriptionRedundancy(this.getSubscriptionRedundancy()));
        clientCacheFactory.setPoolThreadLocalConnections(pool.getThreadLocalConnections(this.getThreadLocalConnections()));
        boolean noServers = this.getServers().isEmpty();
        boolean hasServers = !noServers;
        boolean noLocators = this.getLocators().isEmpty();
        boolean bl = hasLocators = !noLocators;
        if (hasServers || noLocators) {
            List<InetSocketAddress> servers = pool.getServers(this.getServers().toInetSocketAddresses());
            for (InetSocketAddress server : servers) {
                clientCacheFactory.addPoolServer(server.getHostName(), server.getPort());
                noServers = false;
            }
        }
        if (hasLocators || noServers) {
            List<InetSocketAddress> locators = pool.getLocators(this.getLocators().toInetSocketAddresses());
            for (InetSocketAddress locator : locators) {
                clientCacheFactory.addPoolLocator(locator.getHostName(), locator.getPort());
            }
        }
        return clientCacheFactory;
    }

    Pool resolvePool() {
        BeanFactory beanFactory;
        String poolName;
        Pool localPool = this.getPool();
        if (localPool == null && (localPool = this.findPool(poolName = SpringUtils.defaultIfNull(this.getPoolName(), "gemfirePool"))) == null && (beanFactory = this.getBeanFactory()) instanceof ListableBeanFactory) {
            try {
                Map poolFactoryBeanMap = ((ListableBeanFactory)beanFactory).getBeansOfType(PoolFactoryBean.class, false, false);
                String dereferencedPoolName = SpringUtils.dereferenceBean(poolName);
                if (poolFactoryBeanMap.containsKey(dereferencedPoolName)) {
                    return ((PoolFactoryBean)poolFactoryBeanMap.get(dereferencedPoolName)).getPool();
                }
            }
            catch (BeansException e) {
                this.log.info((Object)String.format("unable to resolve bean of type [%1$s] with name [%2$s]", PoolFactoryBean.class.getName(), poolName));
            }
        }
        return localPool;
    }

    Pool findPool(String name) {
        return PoolManager.find((String)name);
    }

    @Override
    protected <T extends GemFireCache> T createCache(Object factory) {
        return (T)((ClientCacheFactory)factory).create();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isReadyForEvents()) {
            try {
                ((ClientCache)this.fetchCache()).readyForEvents();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (CacheClosedException cacheClosedException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void close(GemFireCache cache) {
        ((ClientCache)cache).close(this.isKeepAlive());
    }

    @Override
    public Class<? extends GemFireCache> getObjectType() {
        ClientCache cache = (ClientCache)this.getCache();
        return cache != null ? cache.getClass() : ClientCache.class;
    }

    public void addLocators(ConnectionEndpoint ... locators) {
        this.locators.add(locators);
    }

    public void addLocators(Iterable<ConnectionEndpoint> locators) {
        this.locators.add(locators);
    }

    public void addServers(ConnectionEndpoint ... servers) {
        this.servers.add(servers);
    }

    public void addServers(Iterable<ConnectionEndpoint> servers) {
        this.servers.add(servers);
    }

    public void setDurableClientId(String durableClientId) {
        this.durableClientId = durableClientId;
    }

    public String getDurableClientId() {
        return this.durableClientId;
    }

    public void setDurableClientTimeout(Integer durableClientTimeout) {
        this.durableClientTimeout = durableClientTimeout;
    }

    public Integer getDurableClientTimeout() {
        return this.durableClientTimeout;
    }

    @Override
    public final void setEnableAutoReconnect(Boolean enableAutoReconnect) {
        throw new UnsupportedOperationException("Auto-reconnect does not apply to clients.");
    }

    @Override
    public final Boolean getEnableAutoReconnect() {
        return Boolean.FALSE;
    }

    public void setFreeConnectionTimeout(Integer freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    public Integer getFreeConnectionTimeout() {
        return this.freeConnectionTimeout;
    }

    public void setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public boolean isKeepAlive() {
        return Boolean.TRUE.equals(this.getKeepAlive());
    }

    public void setLoadConditioningInterval(Integer loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    public Integer getLoadConditioningInterval() {
        return this.loadConditioningInterval;
    }

    public void setLocators(ConnectionEndpoint[] locators) {
        this.setLocators(ConnectionEndpointList.from(locators));
    }

    public void setLocators(Iterable<ConnectionEndpoint> locators) {
        this.getLocators().clear();
        this.addLocators(locators);
    }

    protected ConnectionEndpointList getLocators() {
        return this.locators;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMinConnections(Integer minConnections) {
        this.minConnections = minConnections;
    }

    public Integer getMinConnections() {
        return this.minConnections;
    }

    public void setMultiUserAuthentication(Boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    public Boolean getMultiUserAuthentication() {
        return this.multiUserAuthentication;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPingInterval(Long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public Long getPingInterval() {
        return this.pingInterval;
    }

    public void setPrSingleHopEnabled(Boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    public Boolean getPrSingleHopEnabled() {
        return this.prSingleHopEnabled;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadyForEvents(Boolean readyForEvents) {
        this.readyForEvents = readyForEvents;
    }

    public Boolean getReadyForEvents() {
        return this.readyForEvents;
    }

    public boolean isReadyForEvents() {
        Boolean readyForEvents = this.getReadyForEvents();
        if (readyForEvents != null) {
            return Boolean.TRUE.equals(readyForEvents);
        }
        try {
            return GemfireUtils.isDurable((ClientCache)this.fetchCache());
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public void setServers(ConnectionEndpoint[] servers) {
        this.setServers(ConnectionEndpointList.from(servers));
    }

    public void setServers(Iterable<ConnectionEndpoint> servers) {
        this.getServers().clear();
        this.addServers(servers);
    }

    protected ConnectionEndpointList getServers() {
        return this.servers;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setStatisticsInterval(Integer statisticsInterval) {
        this.statisticsInterval = statisticsInterval;
    }

    public Integer getStatisticsInterval() {
        return this.statisticsInterval;
    }

    public void setSubscriptionAckInterval(Integer subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    public Integer getSubscriptionAckInterval() {
        return this.subscriptionAckInterval;
    }

    public void setSubscriptionEnabled(Boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public Boolean getSubscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    public void setSubscriptionMessageTrackingTimeout(Integer subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    public Integer getSubscriptionMessageTrackingTimeout() {
        return this.subscriptionMessageTrackingTimeout;
    }

    public void setSubscriptionRedundancy(Integer subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    public Integer getSubscriptionRedundancy() {
        return this.subscriptionRedundancy;
    }

    public void setThreadLocalConnections(Boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    public Boolean getThreadLocalConnections() {
        return this.threadLocalConnections;
    }

    @Override
    public final void setUseClusterConfiguration(Boolean useClusterConfiguration) {
        throw new UnsupportedOperationException("Shared, cluster-based configuration is not applicable for clients.");
    }

    @Override
    public final Boolean getUseClusterConfiguration() {
        return Boolean.FALSE;
    }
}

